% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manageDatasets.R
\name{bindDatasets}
\alias{bindDatasets}
\title{Bind Generated Datasets}
\usage{
bindDatasets(..., datasetList = list(...))
}
\arguments{
\item{...}{multiple datasets to be bound together}

\item{datasetList}{list of datasets created with one of the generate dataset
functions}
}
\value{
merged list with generators and the contents of the prepared
  dataset. See `\code{\link{prepareMixedEffectDataset}} and
  \code{\link{generateAnovaDatasets}} for a description of the contents.
}
\description{
This method can be used to bind multiple datasets generated using different
random genrators into one large dataset. The underlying dataset needs to be
the same.
}
\examples{
  datasets1 <- generateAnovaDatasets(2, 4, 4, 4)
  datasets2 <- generateAnovaDatasets(2, 4, 4, 4)
  datasets <- bindDatasets(datasets1, datasets2)
  data <- datasets$generateData(1)
  stopifnot(data$numberOfDatasets == 4,
            all.equal(datasets2$generateData(1), datasets$generateData(3),
                      check.attributes = FALSE),
            all.equal(datasets2$sphericalRandomEffects(1), datasets$sphericalRandomEffects(3)),
            all.equal(datasets2$createXMatrix(data), datasets$createXMatrix(data)),
            all.equal(datasets2$createZMatrix(data), datasets$createZMatrix(data)))

  preparedDataset <- prepareMixedEffectDataset(Reaction ~ Days + (Days|Subject), sleepstudy)
  datasets1 <- generateMixedEffectDatasets(2, preparedDataset)
  datasets2 <- generateMixedEffectDatasets(2, preparedDataset)
  datasets <- bindDatasets(datasets1, datasets2)
  data <- datasets$generateData(1)
  stopifnot(data$numberOfDatasets == 4,
            all.equal(datasets2$generateData(1), datasets$generateData(3),
                      check.attributes = FALSE),
            all.equal(datasets2$sphericalRandomEffects(1), datasets$sphericalRandomEffects(3)),
            all.equal(datasets2$createXMatrix(data), datasets$createXMatrix(data)),
            all.equal(datasets2$createZMatrix(data), datasets$createZMatrix(data)))
}
\seealso{
\code{\link{splitDatasets}}
}
\author{
Manuel Koller
}
