% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{cell.cycle.score}
\alias{cell.cycle.score}
\title{Compute Cell Cycle Score}
\usage{
cell.cycle.score(environment, knn = 10, cc.genes.path = NA)
}
\arguments{
\item{environment}{\code{environment} object}

\item{knn}{number of nearest neighbor}

\item{cc.genes.path}{optional; path to defined cell cycle genes. Default uses gene sets defined in Kowalczyk, M. S. et al. Single-cell RNA-seq reveals changes in cell cycle and differentiation programs upon aging of hematopoietic stem cells. Genome Res 25, 1860-1872, doi:10.1101/gr.192237.115 (2015).}
}
\value{
a matrix of cell cycle genes activation scores (S, G2M and aggregated S/G2M scores, separately)
}
\description{
Compute the activation of cell cycle genes defined in Kowalczyk, M. S. et al.
}
\examples{
LCMV1 <- setup_LCMV_example()
cell.cycle.score <- cell.cycle.score(LCMV1)
}
