% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{winswgt}
\alias{winswgt}
\alias{weighted_mean_winsorized}
\alias{weighted_total_winsorized}
\alias{svymean_winsorized}
\alias{svytotal_winsorized}
\title{Weighted winsorized mean and trimmed total}
\usage{
weighted_mean_winsorized(x, w, LB = 0.05, UB = 1 - LB, na.rm = FALSE)

weighted_total_winsorized(x, w, LB = 0.05, UB = 1 - LB,
  na.rm = FALSE)

svymean_winsorized(x, design, LB = 0.05, UB = 1 - LB, ...)

svytotal_winsorized(x, design, LB = 0.05, UB = 1 - LB, ...)
}
\arguments{
\item{x}{numeric vector (\code{weighted_mean_winsorized} or
\code{weighted_total_winsorized}); a formula object or variable name
(\code{svymean_winsorized} or \code{svytotal_winsorized})}

\item{w}{numeric vector of weights}

\item{LB}{lower bound of winsorizing, such that \eqn{0 \leq LB < UB \leq 1}}

\item{UB}{upper bound of winsorizing, such that \eqn{0 \leq LB < UB \leq 1}}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{design}{a \code{survey.design} object (see \link[survey]{svydesign}
in \pkg{survey})}

\item{...}{additional arguments (not used)}
}
\value{
Estimate (scalar) or object of class \code{svystat.rob}
}
\description{
Weighted winsorized estimators of the mean and total are available in two forms:
\itemize{
   \item \strong{bare-bone} functions: \code{weighted_mean_winsorized} and
 \code{weighted_total_winsorized},
   \item estimation \strong{methods}: \code{svymean_winsorized} and
 \code{svytotal_winsorized} (incl. variance estimation
 based on the functionality of the \pkg{survey} package).
}
}
\details{
\describe{
   \item{\emph{Overview}}{
   Robust winsorized Horvitz--Thompson total or Hajek mean
 \itemize{
 \item bare-bone functions: return the estimate (no variance estimation)
 \item estimation methods on the basis of \pkg{survey} (incl. variance estimation)
 }
   }
   \item{\emph{Variance}}{
   Variance estimates of the mean or total estimator are computed as first-order
   linearization using the design-based-estimation capabilities available
   in package \pkg{survey}.
   }
   \item{\emph{Domain estimation}}{
   Estimates for domains can be obtained using the \link[survey]{svyby}
   wrapper in the \pkg{survey} package (see examples).
   }
}
}
\note{
\code{winswgt} is a generic name for the functions documented.
}
\section{Utility functions}{

For the methods \code{svymean_winsorized} and \code{svytotal_winsorized}, the following
utility functions can be used
\itemize{
   \item \code{summary} gives a summary of the estimation properties
   \item \code{\link{robweights}} retrieves the robustness weights
   \item \code{coef}, \code{vcov}, \code{residuals}, and \code{fitted}
 retrieve, respectively, the estimate, variance, residuals and fitted
 values
}
}

\examples{
library(survey)
data(api)
dstrat <- svydesign(id=~1, strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
svymean_winsorized(~api00, dstrat, LB = 0.05)
# Domain estimates
svyby(~api00, by = ~stype, design = dstrat, svymean_winsorized, LB = 0.1)
}
\seealso{
\code{\link{svymean_huber}}, \code{\link{svytotal_huber}},
\code{\link{svymean_trimmed}}, \code{\link{svytotal_trimmed}},
\code{\link{weighted_mean_huber}}, \code{\link{weighted_total_huber}},
\code{\link{weighted_mean_trimmed}}, \code{\link{weighted_total_trimmed}}
}
