% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robotstxt.R
\docType{class}
\name{robotstxt}
\alias{robotstxt}
\title{An object representation of robots.txt files}
\format{\code{\link{R6Class}} object.}
\usage{
robotstxt
}
\value{
Object of \code{\link{R6Class}} with method(s) for bot permission checking.
}
\description{
An object representation of robots.txt files
}
\section{Fields}{

\describe{
\item{\code{domain}}{character vector holding domain name for which the robots.txt file is valid;
will be set to NA if not supplied on initialization}

\item{\code{text}}{character vector of text of robots.txt file;
either supplied on initializetion
or automatically downloaded from domain supplied on initialization}

\item{\code{bots}}{character vector of bot names mentionend in robots.txt}

\item{\code{permissions}}{data.frame of bot permissions found in robots.txt file}

\item{\code{host}}{data.frame of host fields found in robots.txt file}

\item{\code{sitemap}}{data.frame of sitemap fields found in robots.txt file}

\item{\code{other}}{data.frame of other - none of the above - fields found in robots.txt file}
}}
\section{Methods}{

\describe{
 \item{\code{
   initialize(domain, text) }}{
   Method called when initialising object via
   \code{robotstxt$new()}. Needs either \code{text} or \code{domain} to be
   present at initialization. If only domain is supplied -- should be seen as
   default -- than the robots.txt file for that domain will be downloaded. If
   \code{text} is supplied as well, nothing will be downloaded. If only
   \code{text} is supplied than domain is set to '???'.
 }
 \item{\code{
   check( path="/", bot="*" ) }}{
   Method for checking whether or not paths are allowed to be accessed by a bot
 }
}
}
\examples{
\dontrun{
rt <- robotstxt$new(domain="google.com")
rt$bots
rt$permissions
rt$check( paths = c("/", "forbidden"), bot="*")
}

}
\keyword{data}

