% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fData.R
\name{warp}
\alias{warp}
\title{Warp elements of a univariate functional dataset}
\usage{
warp(fData, warpings)
}
\arguments{
\item{fData}{the functional dataset whose observations must be warped in
form of \code{fData} object.}

\item{warpings}{the warping functions \eqn{H_1, \ldots, H_N}, in form of
\code{fData} object, defined over the registered/warped grid.}
}
\value{
The function returns the univariate functional dataset of warped
functions, in form of \code{fData} object.
}
\description{
This function carries out the warping of elements of a univariate functional
dataset by using a set of pre-computed warping functions.
}
\details{
Given a univariate functional dataset \eqn{X_1(t), \ldots, X_N(t)} and a set
of warping functions \eqn{H_1(t), \ldots, H_N(t)}, such that:
\deqn{ H_i : s \longrightarrow t = H_i(s), \quad \forall i = 1, \ldots, N,}
where \eqn{s} spans the warped (or registered) grid and \eqn{t} spans the
original grid, the function computes the warping given by the following
composition:
\deqn{ X_1 \circ H_1(t), \ldots, X_N \circ H_N(t).}
}
\examples{
set.seed( 1618033 )

N = 30

t0 = 0
t1 = 1
P = 1e3 + 1

time_grid = seq( t0, t1, length.out = P )

means = round( runif( N,
                      t0 + (t1 - t0) / 8,
                      t1 - (t1 - t0) / 8  ), 3 )

Data = matrix( sapply( means,
                       function( m )( dnorm( time_grid, mean = m, sd = 0.05 ) ) ),
               ncol = P, nrow = N, byrow = TRUE )

fD = fData( time_grid, Data )

# Piecewise linear warpings
template_warping = function( m )( c( time_grid[ time_grid <= 0.5 ] * m / 0.5,
                                     ( time_grid[ time_grid > 0.5 ]
                                       - 0.5 ) * (1 - m ) / 0.5 + m ) )


warpings = matrix( sapply( means, template_warping ),
                   ncol = P,
                   nrow = N, byrow = TRUE )

wfD = fData( time_grid, warpings )

fD_warped = warp( fD, wfD )

dev.new()
par( mfrow = c( 1, 3 ) )
plot( fD,
     main = 'Unregistered functions', xlab = 'actual grid', ylab = 'values'  )
plot( wfD,
     main = 'Warping functions', xlab = 'registered grid',
     ylab = 'actual grid' )
plot( fD_warped,
     main = 'Warped functions', xlab = 'registered grid',
     ylab = 'values' )
}
\seealso{
\code{\link{fData}}
}

