% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_datasets.r
\name{ncdc_datasets}
\alias{ncdc_datasets}
\title{Search NOAA datasets}
\usage{
ncdc_datasets(datasetid = NULL, datatypeid = NULL, stationid = NULL,
  locationid = NULL, startdate = NULL, enddate = NULL, sortfield = NULL,
  sortorder = NULL, limit = 25, offset = NULL, token = NULL,
  dataset = NULL, page = NULL, year = NULL, month = NULL, ...)
}
\arguments{
\item{datasetid}{(optional) Accepts a single valid dataset id. Data returned will be
from the dataset specified.}

\item{datatypeid}{Accepts a valid data type id or a vector or list of data type ids.
(optional)}

\item{stationid}{Accepts a valid station id or a vector or list of station ids}

\item{locationid}{Accepts a valid location id or a vector or list of location ids
(optional)}

\item{startdate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's Climate
Data Online access token generator. (required) Get an API key (=token) at
http://www.ncdc.noaa.gov/cdo-web/token. You can pass your token in as
an argument or store it in your .Rprofile file with an entry like
\itemize{
  \item options("noaakey" = "your-noaa-token")
}}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{year}{THIS IS A DEPRECATED ARGUMENT. Use combination of startdate and enddate
arguments.}

\item{month}{THIS IS A DEPRECATED ARGUMENT. Use combination of startdate and enddate
arguments.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}
}
\value{
A data.frame for all datasets, or a list of length two, each with a data.frame.
}
\description{
From the NOAA API docs: All of our data are in datasets. To retrieve any data
from us, you must know what dataset it is in.
}
\examples{
\dontrun{
# Get a table of all datasets
ncdc_datasets()

# Get details from a particular dataset
ncdc_datasets(datasetid='ANNUAL')

# Get datasets with Temperature at the time of observation (TOBS) data type
ncdc_datasets(datatypeid='TOBS')
## two datatypeid's
ncdc_datasets(datatypeid=c('TOBS', "ACMH"))

# Get datasets with data for a series of the same parameter arg, in this case
# stationid's
ncdc_datasets(stationid='COOP:310090')
ncdc_datasets(stationid=c('COOP:310090','COOP:310184','COOP:310212'))

# Multiple datatypeid's
ncdc_datasets(datatypeid=c('ACMC','ACMH','ACSC'))
ncdc_datasets(datasetid='ANNUAL', datatypeid=c('ACMC','ACMH','ACSC'))

# Multiple locationid's
ncdc_datasets(locationid="FIPS:30091")
ncdc_datasets(locationid=c("FIPS:30103", "FIPS:30091"))
}
}

