% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/isd.R
\name{isd}
\alias{isd}
\alias{isd_stations}
\title{Get NOAA ISD/ISH data from NOAA FTP server.}
\usage{
isd(usaf, wban, year, path = "~/.rnoaa/isd", overwrite = TRUE)

isd_stations(...)
}
\arguments{
\item{usaf,wban}{(character) USAF and WBAN code. Required}

\item{year}{(numeric) One of the years from 1901 to the current year.
Required.}

\item{path}{(character) A path to store the files, a directory. Default:
\code{~/.rnoaa/isd}. Required.}

\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Get NOAA ISD/ISH data from NOAA FTP server.
}
\details{
This function first looks for whether the data for your specific query has
already been downloaded previously in the directory given by the \code{path}
parameter. If not found, the data is requested form NOAA's FTP server. The first time
a dataset is pulled down we must a) download the data, b) process the data, and c) save
a .csv file to disk. The next time the same data is requested, we only have to read
back in the .csv file, and is quite fast. The processing can take quite a long time
since the data is quite messy and takes a bunch of regex to split apart text strings.
See examples below for different behavior.
}
\examples{
\dontrun{
# Get station table
stations <- isd_stations()
head(stations)

# Get data
(res <- isd(usaf="011490", wban="99999", year=1986))
(res <- isd(usaf="011690", wban="99999", year=1993))
(res <- isd(usaf="172007", wban="99999", year=2015))
(res <- isd(usaf="702700", wban="00489", year=2015))

# The first time a dataset is requested takes longer
system.time( isd(usaf="782680", wban="99999", year=2011) )
system.time( isd(usaf="782680", wban="99999", year=2011) )
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa/
}

