% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.nodesplit_function.R
\name{run_nodesplit}
\alias{run_nodesplit}
\title{Perform the node-splitting approach}
\usage{
run_nodesplit(full, n_chains, n_iter, n_burnin, n_thin)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}.
See 'Value' in \code{\link{run_model}}.}

\item{n_chains}{Positive integer specifying the number of chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_thin}{Positive integer specifying the thinning rate for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
An R2jags output on the summaries of the posterior distribution,
  and the Gelman-Rubin convergence diagnostic of the
  following monitored parameters:
  \item{direct}{The summary effect measure (according to the argument
  \code{measure} defined in \code{\link{run_model}}) of each split node based
  on the corresponding trials.}
  \item{indirect}{The indirect summary effect measure (according to the
  argument \code{measure} defined in \code{\link{run_model}}) of each split
  node based on the remaining network after removing (splitting) the
  corresponding node.}
  \item{diff}{The inconsistency parameter for each split node defined as the
  difference between the direct and indirect effect of the corresponding
  split node.}
  \item{tau}{The between-trial standard deviation after each split node, when
  the random-effects model has been specified.}

  Furthermore, the output includes the following element:
  \item{model_assessment}{A data-frame on the measures of model assessment
  after each split node: deviance information criterion,
  total residual deviance, and number of effective parameters.}
}
\description{
Performs the Bayesian node-splitting approach of Dias et al. (2010)
  extended to address aggregate binary and continuous missing participant
  outcome data via the pattern-mixture model (Spineli et al., 2021;
  Spineli, 2019). This model offers a local evaluation of the
  plausibility of the consistency assumption in the network
  (Dias et al., 2010).
}
\details{
\code{run_nodesplit} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{heter_prior},
  \code{mean_misspar}, \code{var_misspar}, \code{ref}, and \code{indic} from
  \code{\link{run_model}} (now contained in the argument \code{full}).
  This prevents specifying a different Bayesian model from that considered
  in \code{\link{run_model}}. Therefore, the user needs first to apply
  \code{\link{run_model}}, and then use \code{run_nodesplit}
  (see 'Examples').

  For a binary outcome, when \code{measure} is "RR" (relative risk) or "RD"
  (risk difference) in \code{\link{run_model}}, \code{run_nodesplit}
  currently performs node-splitting using the odds ratio as effect measure
  for being the \strong{base-case} effect measure in \code{\link{run_model}}
  for a binary outcome (see also 'Details' in \code{\link{run_model}}).

  To perform the Bayesian node-splitting approach, the
  \code{\link{prepare_nodesplit}} function is called which contains the
  WinBUGS code as written by Dias et al. (2010) for binomial and normal
  likelihood to analyse binary and continuous outcome data, respectively.
  \code{\link{prepare_nodesplit}} has been extended to incorporate the
  pattern-mixture model with informative missingness parameters for binary
  and continuous outcome data (see 'Details' in \code{\link{run_model}}).

  \code{run_nodesplit} runs the Bayesian node-splitting approach in
  \code{JAGS}. The progress of the simulation appears on the R console. The
  number of times \code{run_nodesplit} is used appears on the R console as a
  text in red and it equals the number of split nodes (see 'Examples').
  If there are no split nodes in the network, the execution of the function
  will be stopped and an error message will be printed on the R console.

  \code{run_nodesplit} uses the
  \code{\link[gemtc:mtc.nodesplit.comparisons]{mtc.nodesplit.comparisons}}
  function of the R-package
  \href{https://CRAN.R-project.org/package=gemtc}{gemtc}
  to obtain automatically the nodes to split based on the decision rule of
  van Valkenhoef et al. (2016).
  \code{run_nodesplit} uses the option (1) in van Valkenhoef et al. (2016)
  to parameterise multi-arm trials that contain the node-to-split.
  In contrast,
  \code{\link[gemtc:mtc.nodesplit.comparisons]{mtc.nodesplit.comparisons}}
  uses the option (3) in van Valkenhoef et al. (2016).
  Option (1) keeps the baseline arm of the node-to-split in the corresponding
  multi-arms. Option (3) excludes both arms of the node-to-split from the
  corresponding multi-arm trials.

  The output of \code{run_nodesplit} is not end-user-ready.
  The \code{\link{nodesplit_plot}} function inherits the output of
  \code{run_nodesplit} as an S3 object and processes it further to provide an
  end-user-ready output.

  \code{run_nodesplit} can be used only for a network of interventions.
  In the case of two interventions, the execution of the function will
  be stopped and an error message will be printed on the R console.
}
\examples{
data("nma.baker2009")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_baker.rds', package = 'rnmamod'))

\donttest{
# Run random-effects node-splitting approach
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_nodesplit(full = res,
              n_chains = 3,
              n_iter = 1000,
              n_burnin = 100,
              n_thin = 1)
}

}
\references{
Dias S, Welton NJ, Caldwell DM, Ades AE. Checking consistency in mixed
treatment comparison meta-analysis.
\emph{Stat Med} 2010;\bold{29}(7-8):932--44.
doi: 10.1002/sim.3767

Gelman A, Rubin DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136

Spineli LM, Kalyvas C, Papadimitropoulou K. Continuous(ly) missing outcome
data in network meta-analysis: a one-stage pattern-mixture model approach.
\emph{Stat Methods Med Res} 2021;\bold{30}(4):958--75.
doi: 10.1177/0962280220983544

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
doi: 10.1186/s12874-019-0731-y

van Valkenhoef G, Dias S, Ades AE, Welton NJ. Automated generation of
node-splitting models for assessment of inconsistency in network
meta-analysis. \emph{Res Synth Methods} 2016;\bold{7}(1):80--93.
doi: 10.1002/jrsm.1167
}
\seealso{
\code{\link[R2jags:jags]{jags}},
  \code{\link[gemtc:mtc.nodesplit.comparisons]{mtc.nodesplit.comparisons}},
  \code{\link{nodesplit_plot}}, \code{\link{prepare_nodesplit}},
  \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
