% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewXL.R
\name{ViewXL}
\alias{ViewXL}
\title{ViewXL}
\usage{
ViewXL(DataFrame, FilePath, FileName, ViewTempFile = TRUE, mac = FALSE)
}
\arguments{
\item{DataFrame}{This is the dataframe or tbl_df that will be displayed in excel}

\item{FilePath}{If left blank, tempfile will be used. If specified, the excel files will be saved in specified location.}

\item{FileName}{If specified to save csv file, this would be the name. If left blank and a FilePath has been specified, it would prompt the user to add a FileName.}

\item{ViewTempFile}{True by default, if False it will not open the excel file, but merely save it. Only useful if provided with a FilePath.}

\item{mac}{FALSE by default, set to TRUE if using a Mac, else the base::shell.exec will not work.}
}
\value{
File location in promt. Chosen data frame or tbl_df opened directly in excel.
}
\description{
Views a data.frame or tbl_df object in excel, by saving it in R's temporary file directory (see: tempdir()).
Works on Windows or Mac OS - not linux
It will automatically open the excel sheet. User has the choice too of overriding the file location by setting the FilePath directly.
It is recommended to save the output and use 'unlink' to delete afterwards. See ?ViewXL
}
\examples{
\dontrun{
df <- data.frame( date = seq(
as.Date("2012-01-01"),
as.Date("2015-08-18"),"day"),
x = rnorm(1326, 10,2))
x <- ViewXL(df)
# After viewing, it is recommended to delete the temporary file created using:
unlink(x)
}
}
