% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_islands.R
\name{ms_filter_islands}
\alias{ms_filter_islands}
\title{Remove small detached polygons (islands)}
\usage{
ms_filter_islands(
  input,
  min_area = NULL,
  min_vertices = NULL,
  drop_null_geometries = TRUE,
  ...
)
}
\arguments{
\item{input}{spatial object to filter. One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{min_area}{minimum area of polygons to retain. Area is calculated using
planar geometry, except for the area of unprojected polygons, which is
calculated using spherical geometry in units of square meters.}

\item{min_vertices}{minimum number of vertices in polygons to retain.}

\item{drop_null_geometries}{should features with empty geometries be dropped?
Default \code{TRUE}. Ignored for \code{SpatialPolyons*}, as it is always
\code{TRUE}.}

\item{...}{
  Arguments passed on to \code{\link[=apply_mapshaper_commands]{apply_mapshaper_commands}}
  \describe{
    \item{\code{force_FC}}{should the output be forced to be a FeatureCollection (or sf object or
Spatial*DataFrame) even if there are no attributes? Default \code{TRUE}. If FALSE and
there are no attributes associated with the geometries, a
GeometryCollection (or Spatial object with no dataframe, or sfc) will be output.}
    \item{\code{sys}}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}
    \item{\code{sys_mem}}{How much memory (in GB) should be allocated if using the system
mapshaper (\code{sys = TRUE})? Default 8. Ignored if \code{sys = FALSE}.
This can also be set globally with the option \code{"mapshaper.sys_mem"}}
    \item{\code{quiet}}{If \code{sys = TRUE}, should the mapshaper messages be silenced? Default \code{FALSE}.
This can also be set globally with the option \code{"mapshaper.sys_quiet"}}
  }}
}
\value{
object with only specified features retained, in the same class as
the input
}
\description{
Remove small detached polygons, keeping those with a minimum area and/or a
minimum number of vertices. Optionally remove null geometries.
}
\examples{
library(geojsonsf)
library(sf)

poly <- structure("{\"type\":\"FeatureCollection\",
           \"features\":[{\"type\":\"Feature\",\"properties\":{},
           \"geometry\":{\"type\":\"Polygon\",
           \"coordinates\":[[[102,2],[102,4],[104,4],[104,2],[102,2]]]}},
           {\"type\":\"Feature\",\"properties\":{},
           \"geometry\":{\"type\":\"Polygon\",
           \"coordinates\":[[[100,2],[98,4],[101.5,4],[100,2]]]}},
           {\"type\":\"Feature\",\"properties\":{},
           \"geometry\":{\"type\":\"Polygon\",
           \"coordinates\":[[[100,0],[100,1],[101,1],[101,0],[100,0]]]}}]}",
           class = c("geojson", "json"))

poly <- geojson_sf(poly)
plot(poly)

out <- ms_filter_islands(poly, min_area = 12391399903)
plot(out)

}
