% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings.R
\name{matrix_form,listing_df-method}
\alias{matrix_form,listing_df-method}
\title{Transform \code{rtable} to a list of matrices which can be used for outputting}
\usage{
\S4method{matrix_form}{listing_df}(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  fontspec = font_spec,
  col_gap = 3L
)
}
\arguments{
\item{obj}{(\code{ANY})\cr object to be transformed into a ready-to-render form (a \code{\link[formatters]{MatrixPrintForm}} object).}

\item{indent_rownames}{(\code{flag})\cr silently ignored, as listings do not have row names
nor indenting structure.}

\item{expand_newlines}{(\code{flag})\cr this should always be \code{TRUE} for listings. We keep it
for debugging reasons.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[formatters:font_spec]{font_spec()}}.}

\item{col_gap}{(\code{numeric(1)})\cr the gap to be assumed between columns, in number of spaces with
font specified by \code{fontspec}.}
}
\value{
a \link[formatters:MatrixPrintForm]{formatters::MatrixPrintForm} object.
}
\description{
Although \code{rtable}s are represented as a tree data structure when outputting the table to ASCII or HTML,
it is useful to map the \code{rtable} to an in-between state with the formatted cells in a matrix form.
}
\examples{
lsting <- as_listing(mtcars)
mf <- matrix_form(lsting)

}
\seealso{
\code{\link[formatters:matrix_form]{formatters::matrix_form()}}
}
