% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list.class}
\alias{list.class}
\title{Classify list members into unique cases evaluated by given expression.}
\usage{
list.class(.data, expr, ..., sort.cases = TRUE, envir = parent.frame())
}
\arguments{
\item{.data}{\code{list}}

\item{expr}{A lambda expression}

\item{...}{Additional parameters passed to \code{unique}}

\item{sort.cases}{\code{logical}. if \code{TRUE} the cases will be sorted in ascending order.}

\item{envir}{The environment to evaluate mapping function}
}
\description{
Classify list members into unique cases evaluated by given expression.
}
\examples{
\dontrun{
x <-
  list(
    p1=list(name="Ken",age=24,
      interest=c("reading","music","movies"),
      lang=list(r=2,csharp=4,python=3)),
    p2=list(name="James",age=25,
      interest=c("sports","music"),
      lang=list(r=3,java=2,cpp=5)),
    p3=list(name="Penny",age=24,
      interest=c("movies","reading"),
      lang=list(r=1,cpp=4,python=2)))
list.class(x,interest)
list.class(x,names(lang))
}
}

