% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{mapCellMeta}
\alias{mapCellMeta}
\title{Create new variable from categories in cellMeta}
\usage{
mapCellMeta(object, from, newTo = NULL, ...)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{from}{The name of the original variable to be mapped from.}

\item{newTo}{The name of the new variable to store the mapped result. Default
\code{NULL} returns the new variable (factor class).}

\item{...}{Mapping criteria, argument names are original existing categories
in the \code{from} and values are new categories in the new variable.}
}
\value{
When \code{newTo = NULL}, a factor object of the new variable.
Otherwise, the input object with variable \code{newTo} updated in
\code{cellMeta(object)}.
}
\description{
Designed for fast variable creation when a new variable is going to be
created from existing variable. For example, multiple samples can be mapped
to the same study design condition, clusters can be mapped to cell types.
}
\examples{
pbmc <- mapCellMeta(pbmc, from = "dataset", newTo = "modal",
                    ctrl = "rna", stim = "rna")
}
