% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotFeature}
\alias{plotFeature}
\title{Plot specific feature on t-SNE coordinates}
\usage{
plotFeature(
  object,
  feature,
  by.dataset = TRUE,
  discrete = NULL,
  title = NULL,
  pt.size = 0.3,
  text.size = 3,
  do.shuffle = TRUE,
  rand.seed = 1,
  do.labels = FALSE,
  axis.labels = NULL,
  do.legend = TRUE,
  legend.size = 5,
  option = "plasma",
  cols.use = NULL,
  zero.color = "#F5F5F5",
  return.plots = FALSE
)
}
\arguments{
\item{object}{\code{liger} object. Should call runTSNE or runUMAP before calling.}

\item{feature}{Feature to plot (should be column from cell.data slot).}

\item{by.dataset}{Whether to generate separate plot for each dataset (default TRUE).}

\item{discrete}{Whether to treat feature as discrete; if left NULL will infer from column class
in cell.data (if factor, treated like discrete) (default NULL).}

\item{title}{Plot title (default NULL).}

\item{pt.size}{Controls size of points representing cells (default 0.3).}

\item{text.size}{Controls size of plot text (cluster center labels) (default 3).}

\item{do.shuffle}{Randomly shuffle points so that points from same dataset are not plotted
one after the other (default TRUE).}

\item{rand.seed}{Random seed for reproducibility of point shuffling (default 1).}

\item{do.labels}{Print centroid labels for categorical features (default FALSE).}

\item{axis.labels}{Vector of two strings to use as x and y labels respectively.}

\item{do.legend}{Display legend on plots (default TRUE).}

\item{legend.size}{Size of legend spots for discrete data (default 5).}

\item{option}{Colormap option to use for ggplot2's scale_color_viridis (default 'plasma').}

\item{cols.use}{Vector of colors to form gradient over instead of viridis colormap (low to high).
Only applies to continuous features (default NULL).}

\item{zero.color}{Color to use for zero values (no expression) (default '#F5F5F5').}

\item{return.plots}{Return ggplot plot objects instead of printing directly (default FALSE).}
}
\value{
List of ggplot plot objects (only if return.plots TRUE, otherwise prints plots to
  console).
}
\description{
Generates one plot for each dataset, colored by chosen feature (column) from cell.data slot.
Feature can be categorical (factor) or continuous.
Can also plot all datasets combined with by.dataset = FALSE.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 1)
ligerex <- quantile_norm(ligerex)
ligerex <- runTSNE(ligerex)
plotFeature(ligerex, "nUMI", pt.size = 1)
}
