test_that("christofides works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- ChristofidesRunner(s, t, d, 4)
  expect_equal(out[[1]], c(3, 1, 2, 4))
  expect_equal(out[[2]], 14)
})

test_that("greedy works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- GreedyTSPRunner(s, t, d, 4)
  expect_equal(out[[1]], c(1, 2, 4, 3))
  expect_equal(out[[2]], 14)
})

test_that("insertion works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- InsertionTSPRunner(s, t, d, 4)
  expect_equal(out[[1]], c(1, 2, 3, 4))
  expect_equal(out[[2]], 14)
})

test_that("Nearest Neighbor works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- NearestNeighborTSPRunner(s, t, d, 4)
  expect_equal(out[[1]], c(3, 1, 2, 4))
  expect_equal(out[[2]], 14)
})

test_that("opt2tsp works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- Opt2TSPRunner(s, t, d, 4)
  expect_equal(out[[1]], c(1, 2, 3, 4))
  expect_equal(out[[2]], 14)
})

test_that("traveling saleperson works", {
  s <- c(1, 1, 1, 2, 2, 3)
  t <- c(2, 3, 4, 3, 4, 4)
  d <- c(1, 2, 3, 4, 5, 6)
  out <- TravelingSalesperson(s, t, d, 4, 999999, "Christofides")
  expect_equal(out[[1]], c(3, 1, 2, 4))
  expect_equal(out[[2]], 14)
  out <- TravelingSalesperson(s, t, d, 4, 999999, "Greedy")
  expect_equal(out[[1]], c(1, 2, 4, 3))
  expect_equal(out[[2]], 14)
  out <- TravelingSalesperson(s, t, d, 4, 999999, "Insertion")
  expect_equal(out[[1]], c(1, 2, 3, 4))
  expect_equal(out[[2]], 14)
  out <- TravelingSalesperson(s, t, d, 4, 999999, "NearestNeighbor")
  expect_equal(out[[1]], c(3, 1, 2, 4))
  expect_equal(out[[2]], 14)
  out <- TravelingSalesperson(s, t, d, 4, 999999, "Opt2")
  expect_equal(out[[1]], c(1, 2, 3, 4))
  expect_equal(out[[2]], 14)
  expect_error(TravelingSalesperson(s, t, d, 4, 999999, "abc"), "Invalid")
})
