\name{dic.samples}
\alias{dic}
\alias{dic.samples}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Generate penalized deviance samples}
\description{
  Function to extract random samples of the penalized deviance from
  a \code{jags} model.
}
\usage{
dic.samples(model, n.iter, thin = 1, type, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{a jags model object}
  \item{n.iter}{number of iterations to monitor}
  \item{thin}{thinning interval for monitors}
  \item{type}{type of penalty to use}
  \item{...}{optional arguments passed to the update method for jags
             model objects}
}
\details{

  The \code{dic.samples} function generates penalized deviance
  statistics for use in model comparison.  The two alternative penalized
  deviance statistics generated by \code{dic.samples} are the deviance
  information criterion (DIC) and the penalized expected deviance.
  These are chosen by giving the values ``pD'' and ``popt'' respectively
  as the \code{type} argument.

  DIC (Spiegelhalter et al 2002) is calculated by adding the ``effective
  number of parameters'' (\code{pD}) to the expected deviance. The
  definition of \code{pD} used by \code{dic.samples} is the one proposed
  by Plummer (2002) and requires two or more parallel chains in the
  model.

  DIC is an approximation to the penalized plug-in deviance, which is
  used when only a point estimate of the parameters is of interest. The
  DIC approximation only holds asymptotically when the effective number
  of parameters is much smaller than the sample size, and the model
  parameters have a normal posterior distribution.

  The penalized expected deviance (Plummer 2008) is calculated by adding
  the optimism (\code{popt}) to the expected deviance.  The \code{popt}
  penalty is at least twice the size of the \code{pD} penalty, and
  penalizes complex models more severely.

}
\value{
  An object of class ``dic''. This is a list containing the following
  elements:
  \item{deviance}{A numeric vector, with one element for each 
    observed stochastic node, containing the mean deviance for that node}
  \item{penalty}{A numeric vector, with one element for each 
    observed stochastic node, containing an estimate of the contribution
    towards the penalty}
  \item{type}{A string identifying the type of penalty: ``pD'' or
    ``popt''}
}
\note{
  The \code{popt} penalty is estimated by importance weighting, and may
  be numerically unstable.  
}  
\author{Martyn Plummer}
\references{
  Spiegelhalter, D., N. Best, B. Carlin, and A. van der Linde (2002),
  Bayesian measures of model complexity and fit (with discussion).
  \emph{Journal of the Royal Statistical Society Series B}
  \bold{64}, 583-639.

  Plummer, M. (2002),
  Discussion of the paper by Spiegelhalter et al.
  \emph{Journal of the Royal Statistical Society Series B}
  \bold{64}, 620.

  Plummer, M. (2008)
  Penalized loss functions for Bayesian model comparison.
  \emph{Biostatistics}
  doi: 10.1093/biostatistics/kxm049
}
\seealso{\code{\link{diffdic}}}
\keyword{models}
