% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectbraiding.R
\name{routelist}
\alias{routelist}
\title{Detect Multiple Routes}
\usage{
routelist(startseg, endseg, rivers, reps = 100)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{rivers}{The river network object to use}

\item{reps}{Number of randomized reorderings to try.  Larger numbers will 
result in a more comprehensive list of routes, but computation can be slow,
particularly in the presence of a complex river network.}
}
\value{
A list of vectors, each describing a route in segment numbers.
}
\description{
Called internally within \link{riverdistancelist}.  Detects many
  sequential routes from one river network segment to another, in the event
  of braiding.  Different routes are detected by randomly reordering the
  segment numbers of the input river network object, thus changing the
  internal hierarchy of segment selection.
}
\note{
Since this function uses randomization, there is no guarantee that the 
  list of routes will be comprehensive.  Larger numbers of \code{reps} can be
  tried, but computation can be slow, particularly in the presence of a
  complex river network.  It may be advantageous to use \link{trimriver} to
  create a smaller, more specific river network object to work with.
}
\examples{
data(KilleyW)
plot(x=KilleyW)

routelist(startseg=1, endseg=16, rivers=KilleyW, reps=1000)
}
\author{
Matt Tyers
}

