% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectroute_riverdistance.R
\name{riverdistance}
\alias{riverdistance}
\title{River Distance}
\usage{
riverdistance(startseg = NULL, endseg = NULL, startvert, endvert, rivers,
  path = NULL, map = FALSE, add = FALSE, stopiferror = TRUE,
  algorithm = NULL)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{startvert}{Vertex number of the start of the route}

\item{endvert}{Vertex number of the end of the route}

\item{rivers}{The river network object to use}

\item{path}{(optional) The vector-format route of segment numbers can also be
supplied instead of the starting and ending segments.}

\item{map}{Whether or not to draw a sanity-check map, showing the calculated 
route in entirety.  Defaults to FALSE.}

\item{add}{If \code{map==TRUE}, whether to add the route drawing to an
existing plot (\code{add=TRUE}) or produce a new plot (\code{add=FALSE}).}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be 
found.  If this is set to \code{FALSE} and a route cannot be found, 
\code{riverdistance()} will return \code{NA}.  Defaults to \code{TRUE}. 
See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
Total route distance, in the units of the coordinate system used 
  (this will likely be meters).
}
\description{
Calculates the total river network distance between two points 
  on the river network, given in river locations (segment and vertex).
}
\note{
Building routes from the river mouth to each river network segment may
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk)
riverdistance(startseg=6, endseg=14, startvert=100, endvert=200, rivers=Gulk)
riverdistance(startvert=100, endvert=200, path=c(6,3,4,10,11,14), rivers=Gulk)
riverdistance(startseg=6, endseg=14, startvert=100, endvert=200, rivers=Gulk, map=TRUE)
      
# speed comparison: before and after building routes for each segment...
data(abstreams)
plot(x=abstreams)
abstreams1 <- abstreams
abstreams1$segroutes <- NULL #taking out the $segroutes component

# before
tstart <- Sys.time()
riverdistance(startseg=120, endseg=111, startvert=20, endvert=20, rivers=abstreams1)
tend <- Sys.time()
tend - tstart

# after
tstart <- Sys.time()
riverdistance(startseg=120, endseg=111 ,startvert=20, endvert=20, rivers=abstreams)
tend <- Sys.time()
tend - tstart

}
\author{
Matt Tyers
}

