% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestroute_cleanup.R
\name{addverts}
\alias{addverts}
\title{Add Vertices To Maintain a Minumum Distance Between Vertices}
\usage{
addverts(rivers, mindist = 500)
}
\arguments{
\item{rivers}{The river network object to use.}

\item{mindist}{The minimum distance to use between vertices.  Defaults to 500.}
}
\value{
A new river network object with the specified segments connected (see \link{rivernetwork})
}
\description{
In certain cases, such as when there is a lake within a river system, there may be long, straight lines in a river network with vertices only at either end.
In these cases, any point data along these stretches would be snapped to the vertices at either end.  This function automatically
adds equally-spaced vertices along the straight line, according to a specified minimum allowable distance between vertices.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Kenai3)
Kenai3split <- addverts(Kenai3,mindist=200)

zoomtoseg(seg=c(73,70,71), rivers=Kenai3)
points(Kenai3$lines[[71]])        # vertices before adding

zoomtoseg(seg=c(73,70,71), rivers=Kenai3split)
points(Kenai3split$lines[[71]])   # vertices after adding
}
\author{
Matt Tyers
}
\seealso{
line2network
}

