% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Plot bar charts of population frequencies.}
\usage{
plot_bar(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = num$N, by = "all", dir = 1,
  scale = "f", round = TRUE, f_lbl = "num", f_lwd = 1, lty = 0,
  lbl_txt = txt, title_lbl = txt$scen_lbl, col_pal = pal,
  mar_notes = TRUE, ...)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
(This value is not represented in the plot,
but used when new frequency information \code{\link{freq}}
and a new population table \code{\link{popu}}
are computed from scratch from current probabilities.)}

\item{by}{A character code specifying the perspective
(or the dimension by which the population is split into 2 subsets)
with the following options:
  \enumerate{
  \item \code{by = "cd"}: by condition;
  \item \code{by = "dc"}: by decision;
  \item \code{by = "ac"}: by accuracy;
  \item \code{by = "all"} combines perspectives (5 bars, default).
  }}

\item{dir}{Number of directions in which bars are plotted.
Options:
\enumerate{
  \item \code{dir = 1}: uni-directional bars (all up, default);
  \item \code{dir = 2}: bi-directional bars (up vs. down).
  }}

\item{scale}{Scale the heights of bars either
by current frequencies (\code{scale = "f"}) or
by exact probabilities (\code{scale = "p"}).
Default: \code{scale = "f"}.
For large population sizes \code{\link{N}} and
when \code{round = FALSE}, both settings yield the same bar heights.}

\item{round}{Boolean option specifying whether computed frequencies
are to be rounded to integers.
Default: \code{round = TRUE}.}

\item{f_lbl}{Type of frequency labels, as character code with the following options:
\enumerate{
  \item \code{f_lbl = "nam"}: names;
  \item \code{f_lbl = "num"}: numeric values (default);
  \item \code{f_lbl = "abb"}: abbreviated names;
  \item \code{f_lbl = NA/NULL/"no"}: no labels;
  \item \code{f_lbl = "any"}: abbreviated names and numeric values (abb = num).
  }}

\item{f_lwd}{Line width of frequency box (border).
Values of \code{NA/NULL/0} set \code{lwd} to
invisible \code{tiny_lwd <- .001} and \code{lty <- 0} (\code{"blank"}).
Default: \code{f_lwd = 1}.}

\item{lty}{Line type of frequency box (border).
Values of \code{NA/NULL/0} set \code{lty} to
\code{lty <- 0}.
Default: \code{lty = 0} (i.e., no line).}

\item{lbl_txt}{Current text information (for labels, titles, etc.).
Default: \code{lbl_txt = \link{txt}} (see \code{\link{init_txt}}).}

\item{title_lbl}{Text label for current plot title.
Default: \code{title_lbl = txt$scen_lbl}.}

\item{col_pal}{Current color palette.
Default: \code{col_pal = \link{pal}} (see \code{\link{init_pal}}).}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = TRUE}.}

\item{...}{Other (graphical) parameters
(e.g., \code{cex}, \code{font}, \code{lty}, etc.).}
}
\description{
\code{plot_bar} draws bar charts that
represent the proportions of frequencies in the current
population \code{\link{popu}} as relatives sizes of
rectangular areas.
}
\details{
If a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
is provided, new frequency information \code{\link{freq}}
and a new population table \code{\link{popu}}
are computed from scratch.  Otherwise, the existing
population \code{\link{popu}} is shown.

By default, \code{plot_bar} uses current frequencies
(i.e., rounded or not rounded, depending on the value of \code{round})
as bar heights, rather than using exact probabilities to
scale bar heights (i.e., default scaling is \code{scale = "f"}).
Using the option \code{scale = "p"} scales bar heights
by probabilities (e.g., showing bars for non-natural frequencies
even when frequencies are rounded).
When \code{round = FALSE}, bar heights for \code{scale = "f"}
and for \code{scale = "p"} are identical.

The distinction between \code{scale = "f"} and
\code{scale = "p"} matters mostly for
small populations sizes \code{\link{N}}
(e.g., when \code{\link{N} < 100}).
For rounded and small frequency values (e.g., \code{\link{freq} < 10})
switching from \code{scale = "f"} to \code{scale = "p"}
yields different plots.

\code{plot_bar} contrasts compound frequencies along 1 dimension (height).
See \code{\link{plot_mosaic}} for 2-dimensional visualizations (as areas)
and various \code{box}) options in
\code{\link{plot_tree}} and \code{\link{plot_fnet}}
for related functions.
}
\examples{
# Basics:
plot_bar(prev = .33, sens = .75, spec = .66, title_lbl = "Test 1")

plot_bar(N = 1000, prev = .33, sens = .75, spec = .60,
         title_lbl = "Test 2")  # by "all" (default)

# Perspectives (by):
plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "cd",
         title_lbl = "Test 3a")  # by condition
plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "cd", dir = 2,
         title_lbl = "Test 3b", f_lbl = "num")  # bi-directional

plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "dc",
         title_lbl = "Test 4a")  # by decision
plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "dc", dir = 2,
         title_lbl = "Test 4b", f_lbl = "num")  # bi-directional

plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "ac",
         title_lbl = "Test 5a")  # by accuracy
plot_bar(N = 1000, prev = .33, sens = .75, spec = .60, by = "ac", dir = 2,
         title_lbl = "Test 5b", f_lbl = "num")  # bi-directional

# Customize colors and text:
plot_bar(dir = 1, f_lbl = "num", col_pal = pal_org)
plot_bar(dir = 2, f_lbl = "nam", col_pal = pal_mod)

# Frequency labels (f_lbl):
plot_bar(f_lbl = "def")  # default labels: name = num
plot_bar(f_lbl = "nam")  # name only
plot_bar(f_lbl = "num")  # numeric value only
plot_bar(f_lbl = "abb")  # abbreviated name
plot_bar(f_lbl = NA)     # no labels (NA/NULL/"no")

# Scaling and rounding effects:
plot_bar(N = 3, prev = .1, sens = .7, spec = .6, dir = 2,
         scale = "f", round = TRUE,
         title_lbl = "Rounding (1)") # => Scale by freq and round freq.
plot_bar(N = 3, prev = .1, sens = .7, spec = .6, dir = 2,
         scale = "p", round = TRUE,
         title_lbl = "Rounding (2)") # => Scale by prob and round freq.
plot_bar(N = 3, prev = .1, sens = .7, spec = .6, dir = 2,
         scale = "f", round = FALSE,
         title_lbl = "Rounding (3)") # => Scale by freq and do NOT round freq.
plot_bar(N = 3, prev = .1, sens = .7, spec = .6, dir = 2,
         scale = "p", round = FALSE,
         title_lbl = "Rounding (4)") # => Scale by prob and do NOT round freq.

}
\seealso{
\code{\link{comp_popu}} computes the current population;
\code{\link{popu}} contains the current population;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{freq}} contains current frequency information;
\code{\link{num}} for basic numeric parameters;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_area}}, \code{\link{plot_curve}},
  \code{\link{plot_fnet}}, \code{\link{plot_icons}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_prism}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}
}
\concept{visualization functions}
