% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{BCADtocalBP}
\alias{BCADtocalBP}
\title{calculate cal BP ages from cal BC/AD ages}
\usage{
BCADtocalBP(x, zero = TRUE)
}
\arguments{
\item{x}{The cal BCAD age(s) to be translated into cal BP age(s). BC ages are negative, AD ages are positive.}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to \code{zero=TRUE}.}
}
\value{
The cal BP age(s).
}
\description{
calculate cal BP ages from cal BC/AD ages
}
\details{
Turn cal BC/AD (or BCE/CE) ages into cal BP ages. Negative ages indicate BC, positive ages AD. Since the Gregorian and Julian calendars do not include 0 BC/AD (i.e., 31 December of 1 BC is followed by 1 January of AD 1), zero can be omitted. The years then go from -1 (i.e., 1 BC) to 1 AD. Other calendars, such as the astronomical one, do include zero. The often-used BCE/CE ages are equivalent to BC/AD.
}
\examples{
 BCADtocalBP(2024)
 BCADtocalBP(-1, zero=TRUE)
 BCADtocalBP(-1, zero=FALSE)
}
