% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{as.one}
\alias{as.one}
\title{Combine multiple radiocarbon dates assuming they belong to the same single year}
\usage{
as.one(
  y,
  er,
  cc = 1,
  postbomb = FALSE,
  is.F = FALSE,
  as.F = FALSE,
  thiscurve = NULL,
  yrsteps = 1,
  threshold = 0.001,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  cc.dir = NULL,
  age.lim = c(),
  age.lab = c(),
  calib.col = rgb(0, 0, 0, 0.2),
  one.col = rgb(0, 0, 1, 0.5),
  one.height = 4,
  prob = 0.95,
  talk = TRUE,
  roundby = 0,
  bty = "n"
)
}
\arguments{
\item{y}{The set of radiocarbon dates to be tested}

\item{er}{The lab errors of the radiocarbon dates}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{is.F}{Set this to TRUE if the provided age and error are in the F14C realm.}

\item{as.F}{Whether or not to calculate ages in the F14C realm. Defaults to \code{as.F=FALSE}, which uses the C14 realm.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{age.lim}{Limits of the age axis. Calculated automatically by default.}

\item{age.lab}{Label of the age axis. Defaults to cal BP or BC/AD.}

\item{calib.col}{The colour of the individual calibrated ages. Defaults to semi-transparent grey.}

\item{one.col}{The colour of the combined}

\item{one.height}{The height of the combined distribution}

\item{prob}{Probability range for highest posterior density (hpd) values. Defaults to \code{prob=0.95}.}

\item{talk}{Whether or not to provide an analysis of the results}

\item{roundby}{Rounding of reported years. Defaults to 0 decimals}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="n"}.}
}
\value{
The product of all calibrated probabilities over the range of cal BP years.
}
\description{
Combine all calibrated dates by calculating their product for a range of calendar ages, as if all dates belonged to the same (unknown) single calendar age. This assumed that they all belong to the same single year in time. Use with great care, as often dates could stem from material that could have accumulated over a (much) longer time-span, and if so, then the result will be wrong. See Baillie (1991)'s 'suck-in' effect, Journal of Theoretical Archaeology 2, 12-16.
}
\details{
This calculates the product of all calibrated probabilities, over the range of calendar ages to which the radiocarbon ages calibrate.
}
\examples{
  data(shroud)
  as.one(shroud$y,shroud$er, BCAD=TRUE) # but note the scatter!
  Zu <- grep("ETH", shroud$ID) # Zurich lab only
  as.one(shroud$y[Zu],shroud$er[Zu], BCAD=TRUE)
}
\author{
Maarten Blaauw
}
