% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowscale.R
\name{rowscale.matrix}
\alias{rowscale.matrix}
\title{Scale a matrix by row}
\usage{
\method{rowscale}{matrix}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{An matrix}

\item{center}{Logical, passed to \code{scale}. 
to \code{TRUE}}

\item{scale}{Logical, passed to \code{scale}. 
\code{TRUE}}
}
\value{
A matrix with each row scaled.
}
\description{
Scaling a matrix by row can be slightly slower due to a transposing step.
}
\examples{

mat <- matrix(rnorm(20), nrow=4)
rs.mat <- rowscale(mat)

print(mat)
print(rs.mat)
rowMeans(rs.mat)
apply(rs.mat, 1L, sd)

rowscale(mat, center=FALSE, scale=FALSE) ## equal to mat
rowscale(mat, center=TRUE, scale=FALSE)
rowscale(mat, center=FALSE, scale=TRUE)

}
\seealso{
\code{\link{scale}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
