% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{fixWidthStr}
\alias{fixWidthStr}
\title{Shorten strings to strings with a fix width of characters}
\usage{
fixWidthStr(str, nchar = 8, align = c("left", "right"))
}
\arguments{
\item{str}{A vector of strings}

\item{nchar}{The fixed with}

\item{align}{Character, how to align
Strings with more or fewer characters than \code{nchar} are either shortened
or filled (with spaces)}
}
\value{
A vector of strings with fixed widths
}
\description{
Shorten strings to strings with a fix width of characters
}
\note{
\code{NA} will be converted to characters and the same fixed width
will be applied. The behavior is different from \code{\link{shortenStr}},
where \code{NA} is kept as it is.
}
\examples{

inputStrs <- c("abc", "abcd", "abcde", "abcdefg", "NA", NA) 
outputStrs <- fixWidthStr(inputStrs, nchar=4)
stopifnot(all(nchar(outputStrs)==4))

}
\seealso{
\code{\link{shortenStr}}
}
