% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riAFTBART_fit.R
\name{riAFTBART_fit}
\alias{riAFTBART_fit}
\title{Fit a random effect accelerated failure time BART model}
\usage{
riAFTBART_fit(
  M.burnin,
  M.keep,
  M.thin = 1,
  status,
  y.train,
  x.train,
  trt.train,
  x.test,
  trt.test,
  cluster.id,
  verbose = FALSE,
  SA = FALSE,
  prior_c_function_used = NULL,
  gps = NULL
)
}
\arguments{
\item{M.burnin}{A numeric value indicating the number of MCMC iterations to be treated as burn in.}

\item{M.keep}{A numeric value indicating the number of MCMC posterior draws after burn in.}

\item{M.thin}{A numeric value indicating the thinning parameter.}

\item{status}{A vector of event indicators: status = 1 indicates that the event was observed while status = 0 indicates the observation was right-censored.}

\item{y.train}{A vector of follow-up times.}

\item{x.train}{A dataframe or matrix, including all the covariates but not treatments for training data, with rows corresponding to observations and columns to variables.}

\item{trt.train}{A numeric vector representing the treatment groups for the training data.}

\item{x.test}{A dataframe or matrix, including all the covariates but not treatments for testing data, with  rows corresponding to observations and columns to variables.}

\item{trt.test}{A numeric vector representing the treatment groups for the testing data.}

\item{cluster.id}{A vector of integers representing the clustering id. The cluster id should be an integer and start from 1.}

\item{verbose}{A logical indicating whether to show the progress bar. The default is FALSE}

\item{SA}{A logical indicating whether to conduct sensitivity analysis. The default is FALSE.}

\item{prior_c_function_used}{Prior confounding functions used for SA, which is inherited from the sa function. The default is NULL.}

\item{gps}{Generalized propensity score, which is inherited from the sa function. The default is NULL.}
}
\value{
A list with the following elements:
\item{b:}{A matrix including samples from the posterior of the random effects.}
\item{tree:}{A matrix with M.keep rows and nrow(x.train) columns represnting the predicted log survival time for x.train.}
\item{tree.pred:}{A matrix with M.keep rows and nrow(x.test) columns represnting the predicted log survival time for x.test.}
\item{tau:}{A vector representing the posterior samples of tau, the standard deviation of the random effects.}
\item{sigma:}{A vector representing the posterior samples of sigma, the residual/error standard deviation.}
\item{vip:}{A matrix with M.keep rows and ncol(x.train) columns represnting the variable inclusion proportions for each variable.}
}
\description{
This function implements the random effect accelerated failure time BART (riAFT-BART) algorithm.
}
\examples{
\donttest{
library(riAFTBART)
set.seed(20181223)
n = 5       # number of clusters
k = 50      # cluster size
N = n*k     # total sample size
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = stats::rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
sig.error = 0.5
censoring.rate = 0.02
x1 = stats::rnorm(N,0.5,1)
x2 = stats::rnorm(N,1.5,0.5)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
trt.test = sample(c(1,2,3), N, prob = c(0.3,0.4,0.2), replace = TRUE)
error = stats::rnorm(N,0,sig.error)
logtime = alpha + beta1*x1 + beta2*x2 + b[cluster.id] + error
y = exp(logtime)
C = rexp(N, rate=censoring.rate) # censoring times
Y = pmin(y,C)
status = as.numeric(y<=C)
res <- riAFTBART_fit(M.burnin = 10, M.keep = 10, M.thin = 1, status = status,
                      y.train = Y, trt.train = trt.train, trt.test = trt.test,
                      x.train = cbind(x1,x2),
                      x.test = cbind(x1,x2),
                      cluster.id = cluster.id)
}
}
