% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoSet.R
\name{rhoSet}
\alias{rhoSet}
\title{Rho (set)}
\usage{
rhoSet(x, OcSBaserate = NULL, testSetBaserateInflation = 0,
  OcSLength = 10000, replicates = 800, ScSKappaThreshold = 0.9,
  ScSKappaMin = 0.4, ScSPrecisionMin = 0.6, ScSPrecisionMax = 1)
}
\arguments{
\item{x}{The observed kappa value, \code{\link[=getTestSet]{testSet}} or \code{\link{contingencyTable}} that will be tested with rho}

\item{OcSBaserate}{The \code{\link{baserate}} of the observed \code{\link{codeSet}} (defaults to \code{\link{baserate}} of \code{\link[=getTestSet]{testSet}} or \code{\link{contingencyTable}})}

\item{testSetBaserateInflation}{The minimum \code{\link{baserate}} from the sampling procedure}

\item{OcSLength}{The length of the observed \code{\link{codeSet}}}

\item{replicates}{The number of simulated \code{\link[=getTestSet]{codeSets}} to use in the null hypothesis distribution for rho; similar to replicates in a Monte Carlo study}

\item{ScSKappaThreshold}{The maximum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSKappaMin}{The minimum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMin}{The minimum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMax}{The maximum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}
}
\value{
rho for the given parameters

A list of the format:\describe{
\item{rho}{The rho of the \code{\link{codeSet}}}
\item{kappa}{The Cohen's Kappa of the \code{\link{codeSet}}}
}
}
\description{
This function calculates rho and kappa for a given \code{\link[=getTestSet]{testSet}}, and returns a list containing both values. Called by \code{\link{rho}}.
}
\seealso{
\code{\link{rho}}
}
