% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence-diagram.R
\name{plot}
\alias{plot}
\alias{plot.persistence_diagram}
\alias{autoplot.persistence_diagram}
\title{Visualization of persistence diagrams}
\usage{
\method{plot}{persistence_diagram}(
  x,
  dimension = NULL,
  alpha = 0.6,
  max_intervals = 20000,
  legend = FALSE,
  greyblock = TRUE,
  type = c("barcode", "diagram"),
  ...
)

\method{autoplot}{persistence_diagram}(
  x,
  dimension = NULL,
  alpha = 0.6,
  max_intervals = 20000,
  legend = FALSE,
  greyblock = TRUE,
  n = 10L,
  type = c("barcode", "diagram", "density"),
  ...
)
}
\arguments{
\item{x}{An object of class \link{persistence_diagram}.}

\item{dimension}{An integer value specifying the homology dimension to
visualize. Defaults to \code{NULL} in which case the dimension is retrieved
directly in the \link{persistence_diagram} object.}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of
points and lines in the plot. Defaults to \code{0.6}.}

\item{max_intervals}{An integer value specifying the maximal number of
intervals to display. Selected intervals are those with the longest
lifetime. Set it to \code{0} to see them all. Defaults \code{20000L}.}

\item{legend}{A boolean value specifying whether to display the legend about
the homology dimension(s). Defaults to \code{FALSE}.}

\item{greyblock}{A boolean value specifying whether to display a grey lower
triangle in the diagram representation for nicer output. Defaults to
\code{TRUE}.}

\item{type}{A string specifyfing the type of representation. Choices are
\code{"barcode"}, \code{"diagram"} or \code{"density"}. Defaults to \code{"barcode"}.}

\item{...}{Other parameters to be passed on to next methods.}

\item{n}{An integer value specifying the number of bins for plotting the
diagram as a density. Defaults to \code{10L}.}
}
\value{
For \code{\link[=plot.persistence_diagram]{plot.persistence_diagram()}}, \code{NULL}. Otherwise a
\link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
The \code{\link[=plot.persistence_diagram]{plot.persistence_diagram()}} function only displays the plot while the
\code{\link[=autoplot.persistence_diagram]{autoplot.persistence_diagram()}} in addition outputs the \link[ggplot2:ggplot]{ggplot2::ggplot}
object. If one wishes to control graphical properties, it is recommended to
use the latter to retrieve the \link[ggplot2:ggplot]{ggplot2::ggplot} object and modify and/or add
layers as desired.
}
