% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-rips.R
\name{RipsComplex}
\alias{RipsComplex}
\title{R6 Class for Rips Complex}
\description{
The data structure is a one skeleton graph, or Rips graph,
containing edges when the edge length is less or equal to a given
threshold. Edge length is computed from a user given point cloud with a
given distance function, or a distance matrix.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
rc1 <- RipsComplex$new(data = X, max_edge_length = 1)
Xm <- Reduce(rbind, X, init = numeric())
rc2 <- RipsComplex$new(data = Xm, max_edge_length = 1)
D <- dist(Xm)
rc3 <- RipsComplex$new(data = D)
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
rc <- RipsComplex$new(data = X, max_edge_length = 1)
st <- rc$create_simplex_tree(1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other filtrations and reconstructions: 
\code{\link{AlphaComplex}},
\code{\link{TangentialComplex}},
\code{\link{WitnessComplex}}
}
\author{
Clément Maria, Pawel Dlotko, Vincent Rouvreau, Marc Glisse, Yuichi
Ike
}
\concept{filtrations and reconstructions}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{RipsComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RipsComplex-new}{\code{RipsComplex$new()}}
\item \href{#method-RipsComplex-create_simplex_tree}{\code{RipsComplex$create_simplex_tree()}}
\item \href{#method-RipsComplex-clone}{\code{RipsComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RipsComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-RipsComplex-new}{}}}
\subsection{Method \code{new()}}{
\code{RipsComplex} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RipsComplex$new(data, max_edge_length = NULL, sparse = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Either a \verb{n x d} matrix or a length-\code{n} list of
\code{d}-dimensional vectors or a distance matrix stored as a
\code{\link[stats]{dist}} object.}

\item{\code{max_edge_length}}{A numeric value specifying the Rips value.}

\item{\code{sparse}}{A numeric value specifying the approximation parameter
epsilon for buidling a sparse Rips complex. Defaults to \code{NULL} which
builds an exact Rips complex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{RipsComplex}} object storing the Rips complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RipsComplex-create_simplex_tree"></a>}}
\if{latex}{\out{\hypertarget{method-RipsComplex-create_simplex_tree}{}}}
\subsection{Method \code{create_simplex_tree()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RipsComplex$create_simplex_tree(max_dimension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_dimension}}{An integer value specifying the maximal dimension
which the Rips complex will be expanded to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{SimplexTree}} object storing the computed simplex
tree.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RipsComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RipsComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RipsComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
