\name{predict.symbolicRegressionModel}
\alias{predict.symbolicRegressionModel}
\title{Predict method for symbolic regression models}
\usage{
\method{predict}{symbolicRegressionModel}(object, newdata, model = "BEST",
  detailed = FALSE, ...)
}
\arguments{
  \item{object}{A model created by
  \code{\link{symbolicRegression}}.}

  \item{newdata}{A \code{\link{data.frame}} containing
  input data for the symbolic regression model. The
  variables in \code{object$formula} must match column
  names in this data frame.}

  \item{model}{The numeric index of the model function in
  \code{object$population} to use for prediction or
  \code{"BEST"} to use the model function with the best
  training fitness.}

  \item{detailed}{Whether to add metadata to the prediction
  object returned.}

  \item{...}{Ignored in this \code{predict} method.}
}
\value{
A vector of predicted values or, if \code{detailed} is
\code{TRUE}, a list of the following elements: \code{model}
the model used in this prediction \code{response} a matrix
of predicted versus respone values \code{RMSE} the RMSE
between the real and predicted response
}
\description{
Predict values via a model function from a population of
model functions generated by symbolic regression.
}

