% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_interactions_by_taxa}
\alias{get_interactions_by_taxa}
\title{Return interactions involving specific taxa}
\usage{
get_interactions_by_taxa(sourcetaxon, targettaxon = NULL,
  interactiontype = NULL, bbox = NULL, returnobservations = F)
}
\arguments{
\item{sourcetaxon}{Taxa of interest (consumer, predator, parasite); may be
specified as "Genus species" or higher level (e.g., Genus, Family, Class).}

\item{targettaxon}{Taxa of interest (prey, host); may be specified as "Genus
species" or higher level (e.g., Genus, Family, Class)}

\item{interactiontype}{Interaction types of interest (prey, host); may be
specified as listed by get_interaction_types()}

\item{bbox}{Coordinates in EPSG:4326 decimal degrees defining "left, bottom,
right, top" of bounding box}

\item{returnobservations}{if true, all individual observations are returned,
else only distinct relationships}
}
\value{
Returns data frame of interactions
}
\description{
Returns interactions involving specific taxa.  Secondary (target)
taxa and spatial boundaries may also be set
}
\note{
For data sources in which type of interactions were not specified, the interaction is labeled "interacts_with"
}
\examples{
\dontrun{
get_interactions_by_taxa(sourcetaxon = "Rattus")
get_interactions_by_taxa(sourcetaxon = "Aves", targettaxon = "Rattus")
get_interactions_by_taxa(sourcetaxon = "Rattus rattus",
bbox = c(-67.87,12.79,-57.08,23.32))
}
}
\seealso{
Other interactions: \code{\link{get_child_taxa}};
  \code{\link{get_interaction_matrix}};
  \code{\link{get_interaction_table}};
  \code{\link{get_interaction_types}};
  \code{\link{get_interactions}};
  \code{\link{get_predators_of}}; \code{\link{get_prey_of}}
}
\keyword{database}

