% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_multigeary}
\alias{local_multigeary}
\title{Local Multivariate Geary Statistics}
\usage{
local_multigeary(
  w,
  df,
  permutations = 999,
  permutation_method = "complete",
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{df}{A data frame with selected variables only. E.g. guerry["Crm_prs"]}

\item{permutations}{(optional) The number of permutations for the LISA
computation}

\item{permutation_method}{(optional) The permutation method used for the
LISA computation. Options are {'complete', 'lookup'}. Default is 'complete'.}

\item{significance_cutoff}{(optional) A cutoff value for significance
p-values to filter not-significant clusters}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel
LISA computation}

\item{seed}{(optional) The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply local Multivariate Geary statistics
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants',
'Suicids')]
lisa <- local_multigeary(queen_w, data)
lms <- lisa_clusters(lisa)
lms
}
