% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{gd_download}
\alias{gd_download}
\title{Download a Google Earth Engine Image}
\usage{
gd_download(
  x,
  filename = tempfile(fileext = ".tif"),
  region = NULL,
  composite = TRUE,
  overwrite = TRUE,
  silent = TRUE,
  ...
)
}
\arguments{
\item{x, }{ID or Name, or a reference to an object inheriting from \code{geedim.download.BaseImage} or \code{geedim.collection.MaskedCollection}}

\item{filename}{path to output file, defaults to temporary GeoTIFF file path; if \code{composite=FALSE} then this path should be to a parent directory. File names will be calculated from the internal name of the image and the requested scale.}

\item{region}{a GeoJSON-like list, or other R spatial object describing region of interest, see \code{gd_region()} and \code{gd_bbox()} for details. \code{NULL} region (default) will download the whole image.}

\item{composite}{logical. Composite Image Collection into single image for download? Default: \code{TRUE}}

\item{overwrite}{Overwrite existing file? Default: \code{TRUE}}

\item{silent}{Silence errors? Default: \code{TRUE}}

\item{...}{Additional arguments (e.g. \code{scale}) passed to \href{https://geedim.readthedocs.io/en/latest/_generated/geedim.mask.MaskedImage.download.html}{\code{geedim.mask.MaskedImage$download(...)}} and, when \code{composite=TRUE}, \href{https://geedim.readthedocs.io/en/latest/_generated/geedim.collection.MaskedCollection.composite.html}{\code{geedim.collection.MaskedCollection$composite()}}}
}
\value{
Invisible path to downloaded image, or \code{try-error} on error
}
\description{
Download a Google Earth Engine Image
}
\details{
The \code{region} argument is \emph{optional} for downloading images. When downloading a composite Image Collection, you must specify \code{region}, \code{scale} and \code{crs} arguments. When downloading an image collection as a set of GeoTIFF files (\code{composite=FALSE}), then \code{filename} is the destination directory, and \code{scale} must be specified.
The default resampling method in \code{geedim} is \code{resampling="near"} (Nearest Neighbor). Other options for \code{resampling} include: \code{"average"}, \code{"bicubic"}, \code{"bilinear"}. See \code{gd_resampling_methods()}.
}
\examples{
\dontshow{if (gd_is_initialized()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
 r <- gd_bbox(
   xmin = -121,
   xmax = -120.5,
   ymin = 38.5,
   ymax = 39
 )

if (gd_is_initialized()) {
 x <- gd_image_from_id('CSP/ERGo/1_0/Global/SRTM_topoDiversity')
 tf <- tempfile(fileext = ".tif")

 # fast sample download at 10x aggregation (900m v.s. 90m)
 img <- gd_download(x, filename = tf,
                    region = r, scale = 900,
                    overwrite = TRUE, silent = FALSE)

 if (requireNamespace("terra")) {
   library(terra)
   f <- rast(img)
   plot(f[[1]])
   # inspect object
   f
 }
 unlink(tf)
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{gd_region()} \code{gd_bbox()}
}
