% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_Initialize.R
\name{ee_Initialize}
\alias{ee_Initialize}
\title{Authenticate and Initialize Earth Engine}
\usage{
ee_Initialize(
  user = NULL,
  drive = FALSE,
  gcs = FALSE,
  credentials = "persistent",
  opt_url = NULL,
  cloud_api_key = NULL,
  http_transport = NULL,
  project = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{user}{Character (optional, e.g. \code{data.colec.fbf}). The user
argument is used to create a folder inside the path
\code{~/.config/earthengine/} that save all the credentials for a specific
Google identity.}

\item{drive}{Logical (optional). If TRUE, the drive credential
is cached in the path \code{~/.config/earthengine/}.}

\item{gcs}{Logical (optional). If TRUE, the Google Cloud Storage
credential is cached in the path \code{~/.config/earthengine/}.}

\item{credentials}{OAuth2 credentials. 'persistent' (default) means
use credentials already stored in the filesystem, or raise an explanatory
exception guiding the user to create those credentials.}

\item{opt_url}{The base url for the EarthEngine REST API to connect to.}

\item{cloud_api_key}{An optional API key to use the Cloud API.}

\item{http_transport}{The http transport method to use when making requests.}

\item{project}{The client project ID or number to use when making API calls.}

\item{quiet}{Logical. Suppress info messages.}

\item{...}{Extra exporting argument. See \link{ee_Authenticate}.}
}
\value{
No return value, called for initializing the earthengine-api.
}
\description{
Authorize rgee to manage Earth Engine resources, Google
Drive, and Google Cloud Storage. The \code{ee_initialize()} via
web-browser will ask users to sign into your Google account and
allows you to grant permission to manage resources. This function is
a wrapper around \code{rgee::ee$Initialize()}.
}
\details{
\code{ee_Initialize()} can manage Google Drive, and Google
Cloud Storage resources using the R packages googledrive and
googlecloudStorageR, respectively. By default, rgee does not require
them. These are only necessary to enable rgee I/O functionality.
All user credentials are saved in the directory
\code{~/.config/earthengine/}. If a user does not specify the "user"
argument, all user credentials are saved in the the subdirectory
\code{~/.config/earthengine/ndef}.
}
\examples{
\dontrun{
library(rgee)

# Simple init - Load just the Earth Engine credential
ee_Initialize()
ee_user_info()
}
}
\seealso{
Other session management functions: 
\code{\link{ee_user_info}()},
\code{\link{ee_users}()},
\code{\link{ee_version}()}
}
\concept{session management functions}
