% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_Initialize.R
\name{ee_Authenticate}
\alias{ee_Authenticate}
\title{Prompts the user to authorize access to Earth Engine via OAuth2.}
\usage{
ee_Authenticate(
  authorization_code = NULL,
  code_verifier = NULL,
  auth_mode = NULL,
  scopes = NULL,
  quiet = FALSE
)
}
\arguments{
\item{authorization_code}{An optional authorization code.}

\item{code_verifier}{PKCE verifier to prevent auth code stealing.}

\item{auth_mode}{The authentication mode. One of:
\itemize{
\item{1. }{paste - send user to accounts.google.com to get a pastable token}
\item{2. }{notebook - send user to notebook authenticator page}
\item{3. }{gcloud - use gcloud to obtain credentials (will set appdefault)}
\item{4. }{appdefault - read from existing $GOOGLE_APPLICATION_CREDENTIALS file}
\item{5. }{None - a default mode is chosen based on your environment.}
}}

\item{scopes}{List of scopes to use for authentication. Defaults to : 'https://www.googleapis.com/auth/earthengine' or
'https://www.googleapis.com/auth/devstorage.full_control'}

\item{quiet}{If TRUE, do not require interactive prompts.}
}
\description{
Prompts the user to authorize access to Earth Engine via OAuth2.
}
\examples{
\dontrun{
library(rgee)

# Simple init - Load just the Earth Engine credential
ee_Authenticate()
}
}
