% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\docType{methods}
\name{cor,ml.col.def,ml.col.def-method}
\alias{cor,ml.col.def,ml.col.def-method}
\title{Correlation}
\usage{
\S4method{cor}{ml.col.def,ml.col.def}(x, y = NULL, use = NULL,
  method = NULL)
}
\arguments{
\item{x}{a ml.data.frame field.}

\item{y}{a ml.data.frame field}

\item{use}{not used currently}

\item{method}{not used currently}
}
\value{
The correlation coefficient
}
\description{
Returns the Pearson correlation coefficient between two \link{ml.data.frame} fields.
}
\details{
The function eliminates all pairs for which either the first element or the second
element is empty. After the elimination, if the length of the input is less than 2,
the function returns the empty sequence. After the elimination, if the standard
deviation of the first column or the standard deviation of the second column is 0,
the function returns the empty sequence.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn, collection = "iris")
 # return the correlation
 cor(mlIris$Sepal.Length, mlIris$Petal.Length)
}
}

