% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\title{distribution}
\usage{
distribution(species_list, server = getOption("FISHBASE_API", FISHBASE_API),
  limit = 500)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species").}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}
}
\description{
return a table of species locations as reported in FishBASE.org FAO location data
}
\details{
currently this is ~ FAO areas table (minus "note" field)
e.g. http://www.fishbase.us/Country/FaoAreaList.php?ID=5537
}
\examples{
\donttest{
distribution(species_list(Genus='Labroides'))
}
}

