% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_facts.R
\name{write_facts}
\alias{write_facts}
\title{Write modified FACTS files.}
\usage{
write_facts(fields, values, default_dir = "_facts")
}
\arguments{
\item{fields}{Data frame defining the kind of XML data to be replaced.
It must have one row per field definition and the following columns:
\enumerate{
\item \code{field}: custom name of the field.
\item \code{type}: value of the "type" attribute of the \verb{<parameterSets>} tag.
\item \code{set}: value of the "name" attribute of the \verb{<parameterSet>} tag.
\item \code{property}: value of the "name" attribute of the \verb{<property>} tag.
}}

\item{values}{Data frame defining the FACTS files to generate.
Must have one row per FACTS file and a column called \code{facts_file}
with the names of the input FACTS files. An \code{output} column with the
names of the output FACTS files is recommended but not required.
(If \code{output} is not specified, the output FACTS files will be
written to automatically generated paths inside \code{default_dir}.)
Other columns must have names corresponding to elements of \code{fields$field}
and contain values to insert into the FACTS files. These columns could
be vectors or lists of vectors. In the former case, each element
is a scalar replacement to a property. In the latter case,
an XML property receives an entire vector as an item list,
and the vector must be the same length as the original item list.}

\item{default_dir}{Directory to write the output FACTS files
if \code{values} has no \code{output} column.}
}
\value{
The function writes FACTS XML files and
returns a character vector with the paths to those files.
}
\description{
Write modified versions of existing FACTS files.
This function can be used to tweak properties of a FACTS file
such as maximum sample size, number of weeks between interims,
allocation ratios, data generation parameters,
and analysis priors.
}
\details{
A FACTS file has a special kind of XML format.
Most of the content sits in an overarching \verb{<facts>} tag,
then a \verb{<parameterSets>} tag, then a
\verb{<parameterSet>} tag, then a \verb{<property>} tag.
For example, here is the part of a FACTS file that controls
the weeks between interims.\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<facts>
  <parameterSets type="NucleusParameterSet">
    <parameterSet name="nucleus">
      <property name="update_freq_save">4</property>
}\if{html}{\out{</div>}}

To use the \code{write_facts()} function, you must first identify
the parts of the FACTS file you want to modify (the \code{fields} argument)
then the values that should be substituted in (the \code{values} argument).
Given the XML above, to create new FACTS files with intervals
5 and 6 instead of 4, you would set\if{html}{\out{<div class="sourceCode r">}}\preformatted{fields <- tibble::tibble(
  field = "my_interval",
  type = "NucleusParameterSet",
  set = "nucleus",
  property = "update_freq_save"
)
values <- tibble::tibble(
  facts_file = "your_facts_file.facts",
  output = "output_file.facts",
  my_interval = c(5, 6)
)
}\if{html}{\out{</div>}}

and then call \code{write_facts(fields = fields, values = values)}.
}
\examples{
# Identify a source FACTS file.
facts_file <- get_facts_file_example("contin.facts")
# Create 4 new FACTS files with different numbers of max patients.
fields <- data.frame(
  field = "my_subjects",
  type = "NucleusParameterSet",
  set = "nucleus",
  property = "max_subjects"
)
values <- data.frame(
  facts_file = facts_file,
  output = c("_facts/out1000.facts", "_facts/out2000.facts"),
  my_subjects = c(1000, 2000)
)
default_dir <- tempfile()
write_facts(fields = fields, values = values, default_dir = default_dir)
list.files("_facts")
unlink("_facts", recursive = TRUE)
}
