% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facts_engines.R, R/run_engine_aipf_contin.R,
%   R/run_engine_aipf_dichot.R, R/run_engine_aipf_tte.R, R/run_engine_contin.R,
%   R/run_engine_crm.R, R/run_engine_dichot.R, R/run_engine_multep.R,
%   R/run_engine_tte.R
\name{facts_engines}
\alias{facts_engines}
\alias{run_engine_aipf_contin}
\alias{run_engine_aipf_dichot}
\alias{run_engine_aipf_tte}
\alias{run_engine_contin}
\alias{run_engine_crm}
\alias{run_engine_dichot}
\alias{run_engine_multep}
\alias{run_engine_tte}
\title{Engine-specific trial simulation functions}
\usage{
run_engine_aipf_contin(
  param_files,
  n_sims = 1L,
  mode = c("", "r"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  interim = NULL,
  mcmc_num = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_aipf_dichot(
  param_files,
  n_sims = 1L,
  mode = c("", "r"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  interim = NULL,
  mcmc_num = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_aipf_tte(
  param_files,
  n_sims = 1L,
  mode = c("", "r"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  interim = NULL,
  mcmc_num = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_contin(
  param_files,
  n_sims = 1L,
  mode = c("s", "r", "p"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  arm_selection = NULL,
  armsdropped = NULL,
  complete_data_analysis = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  fsimdata = NULL,
  fsimexp = NULL,
  fsimparam = NULL,
  interim = NULL,
  keepfiles = NULL,
  mcmc_num = NULL,
  noadapt = NULL,
  s2_aux_paramfile = NULL,
  stage = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_crm(
  param_files,
  n_sims = 1L,
  mode = c("s", ""),
  directory = ".",
  allocator = NULL,
  charting_info = NULL,
  estimator = NULL,
  force_cohort = NULL,
  reduced_priority = NULL,
  version = NULL,
  verbose = FALSE
)

run_engine_dichot(
  param_files,
  n_sims = 1L,
  mode = c("s", "r", "p"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  arm_selection = NULL,
  armsdropped = NULL,
  complete_data_analysis = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  fsimdata = NULL,
  fsimexp = NULL,
  fsimparam = NULL,
  interim = NULL,
  keepfiles = NULL,
  mcmc_num = NULL,
  noadapt = NULL,
  s2_aux_paramfile = NULL,
  stage = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_multep(
  param_files,
  n_sims = 1L,
  mode = c("s", "r", "p"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  arm_selection = NULL,
  armsdropped = NULL,
  complete_data_analysis = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  fsimdata = NULL,
  fsimexp = NULL,
  fsimparam = NULL,
  interim = NULL,
  keepfiles = NULL,
  mcmc_num = NULL,
  noadapt = NULL,
  s2_aux_paramfile = NULL,
  stage = NULL,
  verbose = FALSE,
  version = NULL
)

run_engine_tte(
  param_files,
  n_sims = 1L,
  mode = c("s", "r", "p"),
  seed = NULL,
  analysis_data = NULL,
  analysis_mode = NULL,
  arm_selection = NULL,
  armsdropped = NULL,
  complete_data_analysis = NULL,
  current_week = NULL,
  execdata = NULL,
  final = NULL,
  fsimdata = NULL,
  fsimexp = NULL,
  fsimparam = NULL,
  interim = NULL,
  keepfiles = NULL,
  mcmc_num = NULL,
  noadapt = NULL,
  s2_aux_paramfile = NULL,
  stage = NULL,
  verbose = FALSE,
  version = NULL
)
}
\arguments{
\item{param_files}{Character vector of file paths or the output
of \code{\link[=prep_param_files]{prep_param_files()}}. If a character vector, the elements
can be directories containing \verb{*.param} files or the paths to the
\verb{*.param} files themselves.
Such a directory is returned by \code{\link[=run_flfll]{run_flfll()}}.}

\item{n_sims}{Positive integer, number of simulations per param file.}

\item{mode}{Character scalar: \code{"s"} for simulation mode in non-enrichment
designs, \code{""} for simulation mode in enrichment designs,
\code{"r"} for execution mode, and \code{"p"} for prediction mode.
For the CRM engine, \code{mode} needs to be \code{"s"} or \code{""}.}

\item{seed}{Positive integer, random number generator seed for the
actual trial simulations. Use this \code{seed} argument instead of
\code{flfll_seed} (\code{\link[=run_facts]{run_facts()}}, \code{\link[=run_flfll]{run_flfll()}}) to control
pseudo-randomness in the actual trial simulations. \code{flfll_seed}
only controls how the \verb{*.param} files are generated.}

\item{analysis_data}{Character, analysis mode patient data file name.}

\item{analysis_mode}{Logical, whether to activate analysis mode.}

\item{current_week}{Numeric, current time in weeks.}

\item{execdata}{Character, name of the execution mode patient file.}

\item{final}{Logical, whether to do the final analysis.
For execution mode only.}

\item{interim}{Integer, interim number.}

\item{mcmc_num}{Integer, MCMC file number. For analysis mode only.}

\item{verbose}{Logical, whether to print progress information to the R
console.}

\item{version}{Character scalar, version of FACTS corresponding to the
FACTS file. Get by calling \code{\link[=get_facts_version]{get_facts_version()}} on your FACTS file.
See possible versions with \code{\link[=get_facts_versions]{get_facts_versions()}}.
Do not supply \code{version} to \code{\link[=run_engine]{run_engine()}}. \code{\link[=run_engine]{run_engine()}}
detects the version automatically from the FACTS file and
passes it to the appropriate engine function.}

\item{arm_selection}{Logical, whether to activate arm selection.}

\item{armsdropped}{Character, a comma-separated collection of integers
indicating dropped arms.}

\item{complete_data_analysis}{Logical, whether to do a complete
data analysis.}

\item{fsimdata}{Character, prediction mode patient data file name.}

\item{fsimexp}{Logical. For expert use only.}

\item{fsimparam}{Character, name of the prediction mode \verb{*.param} file.}

\item{keepfiles}{Logical, whether to deactivate cleanup of
extraneous staged design files.}

\item{noadapt}{Logical, whether to deactivate adaptive actions
in prediction mode.}

\item{s2_aux_paramfile}{Character, name of the stage 2 execution
auxiliary \verb{*.param} file.}

\item{stage}{Integer, trial design stage. For staged designs only.}

\item{directory}{Character, working directory. CRM only.}

\item{allocator}{Logical, allocator/execution/recommender mode. CRM only.}

\item{charting_info}{Logical, unused.}

\item{estimator}{Logical, use estimator. CRM only.}

\item{force_cohort}{Logical, whether to force small cohort run-in to end.
CRM only.}

\item{reduced_priority}{Logical, whether to run at reduced priority.
CRM only.}
}
\value{
Nothing.
}
\description{
These functions are the inner functions called by
\code{\link[=run_engine]{run_engine()}}. In this help file, only the most common engine functions
are listed. To identify the appropriate engine function
for your FACTS file, call \code{\link[=get_facts_engine]{get_facts_engine()}}.
\itemize{
\item \code{\link[=run_engine_aipf_contin]{run_engine_aipf_contin()}}: Enrichment continuous.
\item \code{\link[=run_engine_aipf_dichot]{run_engine_aipf_dichot()}}: Enrichment dichotomous.
\item \code{\link[=run_engine_aipf_tte]{run_engine_aipf_tte()}}: Enrichment time to event.
\item \code{\link[=run_engine_contin]{run_engine_contin()}}: Core continuous.
\item \code{\link[=run_engine_crm]{run_engine_crm()}}: continual reassessment method (CRM).
\item \code{\link[=run_engine_dichot]{run_engine_dichot()}}: Core dichotomous.
\item \code{\link[=run_engine_multep]{run_engine_multep()}}: Multiple endpoint.
\item \code{\link[=run_engine_tte]{run_engine_tte()}}: Time to event.
}
}
\details{
If you need to repeatedly invoke an engine, as with most
trial execution mode workflows, these engine functions may be slow
on their own. To avoid the most severe sources of slowness,
consider running \code{\link[=prep_param_files]{prep_param_files()}}
and then passing the result to one of the individual engine
functions (such as \code{\link[=run_engine_contin]{run_engine_contin()}}).
}
\examples{
facts_file <- get_facts_file_example("contin.facts")
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
out <- run_flfll(facts_file, verbose = FALSE) # Generate param files.
# Identify which engine you need.
get_facts_engine(facts_file)
# Run the sims with the engine function or `run_engine()`.
run_engine_contin(out, n_sims = 1, verbose = FALSE)
read_patients(out)
}
}
\seealso{
\code{\link[=run_engine]{run_engine()}}, \code{\link[=get_facts_file_example]{get_facts_file_example()}},
\code{\link[=get_facts_engine]{get_facts_engine()}}, \code{\link[=run_facts]{run_facts()}}, \code{\link[=run_flfll]{run_flfll()}}.
}
