% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf.imp.freq.R
\name{rf.imp.freq}
\alias{rf.imp.freq}
\title{Random Forest variable selection frequency}
\usage{
rf.imp.freq(x, p = 0.6, plot = TRUE)
}
\arguments{
\item{x}{random forest object}

\item{p}{Threshold of row standardized importance values}

\item{plot}{Plot frequencies (TRUE/FALSE)}
}
\value{
A list class object with the following components:
 frequency:
   vars - names of independent variables used in model
   global - if a variable greater-than/equal-to importance threshold, else NA 
   column for each class where greater-than/equal-to importance threshold, else NA    
   var.freq - frequency a variable is selected for global and local importance >= importance threshold

 importance: 
   Standardized importance matrix from randomForest model
}
\description{
Evaluates the frequency that an independent variables are selected greater-than/equal-to defined importance threshold
}
\note{
Evaluates the number of times a variable is selected greater-than/equal-to defined threshold (p) for the global and local (class level) importances. This allow one to evaluate if a given variable is important to the overall model or specific classes.
}
\examples{
 
 require(randomForest)
 data(iris)
 iris.rf <- randomForest(Species ~ ., data=iris, importance=TRUE)
 rf.imp.freq(iris.rf, p = 0.30)

}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
