% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rfPermute.R
\name{plot.rfPermute}
\alias{plot.rfPermute}
\title{Plot Random Forest Importance Null Distributions.}
\usage{
\method{plot}{rfPermute}(x, imp.type = 1, scale = TRUE, ...)
}
\arguments{
\item{x}{An object produced by a call to \code{\link{rfPermute}}.}

\item{imp.type}{Either a numeric or character vector giving the 
importance metric(s) to plot.}

\item{scale}{Plot importance measures scaled (divided by) standard errors?}

\item{...}{Optional graphical arguments to be sent to \code{\link[graphics]{par}}.}
}
\description{
Plot the Random Forest null distributions importance metrics, 
observed values, and p-values for
each predictor variable from the object produced by a 
call to \code{\link{rfPermute}}.
}
\details{
The function will generate an individual plot for
  each variable and importance metric on the default graphics
  device.
}
\examples{
  # A regression model using the ozone example
  data(airquality)
  ozone.rfP <- rfPermute(Ozone ~ ., data = airquality, ntree = 100, na.action = na.omit, nrep = 50)
  
  # Plot the null distributions and observed values.
  layout(matrix(1:6, nrow = 2))
  plot(ozone.rfP) 
  layout(matrix(1))

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

