% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.plot.r
\name{proximity.plot}
\alias{proximity.plot}
\title{Plot Random Forest Proximity Scores.}
\usage{
proximity.plot(rf, dim.x = 1, dim.y = 2, legend.loc = c("top", "bottom",
  "left", "right"), point.size = 2, circle.size = 8, circle.border = 1,
  plot = TRUE)
}
\arguments{
\item{rf}{A \code{randomForest} object.}

\item{dim.x, dim.y}{Numeric values giving x and y dimensions to plot from 
multidimensional scaling of proximity scores.}

\item{legend.loc}{Character keyword specifying location of legend. 
Can be \code{"bottom", "top", "left", "right"}.}

\item{point.size}{Size of central points.}

\item{circle.size}{Size of circles around correctly classified 
points as argument to 'cex'. Set to NULL for no circles.}

\item{circle.border}{Width of circle border.}

\item{plot}{logical determining whether or not to show plot.}
}
\value{
a list with \code{prox.cmd}: the MDS scores of the selected dimensions, 
  and \code{g} the \code{\link{ggplot}} object.
}
\description{
Create a plot of Random Forest proximity scores using 
  multi-dimensional scaling.
}
\details{
Produces a scatter plot of proximity scores for \code{dim.x} and 
  \code{dim.y} dimensions from a multidimensional scale (MDS) conversion of 
  proximity scores from a \code{randomForest} object. For classification 
  models, a convex hull is drawn around the a-priori classes with points 
  colored according to original (inner) and predicted (outer) class.
}
\examples{
data(mtcars)
rf <- randomForest(factor(am) ~ ., mtcars, proximity = TRUE)
rf
proximity.plot(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

