% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revulytics_auth.R
\name{revulytics_auth}
\alias{revulytics_auth}
\title{Login and Obtain Revultyics API Session Id}
\usage{
revulytics_auth(rev_username, rev_password)
}
\arguments{
\item{rev_username}{Revulytics username.}

\item{rev_password}{Revultyics password.}
}
\value{
A list with details on connection to the Revulytics API.
}
\description{
A session must first be established before querying the API.
This is done using your Revulytics username and password.
}
\details{
It is not recommended that these values be stored directly 
in your code. There are various methods and packages 
available that are more secure; this package does not require
you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
product_ids_list <- c("123", "456", "789")
start_date <- lubridate::floor_date(Sys.Date(), unit = "months") - months(6)
end_date <- Sys.Date() - 1
session_id <- revulytics_auth(rev_user, rev_pwd)
}
}
