% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotatedOutline.R
\name{AnnotatedOutline}
\alias{AnnotatedOutline}
\title{Class containing functions and data relating to annotating outlines}
\value{
AnnotatedOutline object, with extra fields for tears
  latitude of rim \code{phi0} and index of fixed point \code{i0}.
}
\description{
An AnnotatedOutline contains a function to annotate 
  tears on the outline.
}
\examples{
P <- rbind(c(1,1),   c(2,1),  c(2,-1),
           c(1,-1),  c(1,-2), c(-1,-2),
           c(-1,-1), c(-2,-1),c(-2,1),
           c(-1,1),  c(-1,2), c(1,2))
o <- TriangulatedOutline$new(P)
o$addTear(c(3, 4, 5))
o$addTear(c(6, 7, 8))
o$addTear(c(9, 10, 11))
o$addTear(c(12, 1, 2))
flatplot(o)
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{\link[retistruct:Outline]{retistruct::Outline}} -> \code{\link[retistruct:PathOutline]{retistruct::PathOutline}} -> \code{AnnotatedOutline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{tears}}{Matrix in which each row represents a tear by the
indices into the outline points of the apex (\code{V0}) and
backward (\code{VB}) and forward (\code{VF}) points}

\item{\code{phi0}}{rim angle in radians}

\item{\code{lambda0}}{longitude of fixed point}

\item{\code{i0}}{index of fixed point}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AnnotatedOutline$new()}}
\item \href{#method-labelTearPoints}{\code{AnnotatedOutline$labelTearPoints()}}
\item \href{#method-whichTear}{\code{AnnotatedOutline$whichTear()}}
\item \href{#method-getTear}{\code{AnnotatedOutline$getTear()}}
\item \href{#method-getTears}{\code{AnnotatedOutline$getTears()}}
\item \href{#method-computeTearRelationships}{\code{AnnotatedOutline$computeTearRelationships()}}
\item \href{#method-addTear}{\code{AnnotatedOutline$addTear()}}
\item \href{#method-removeTear}{\code{AnnotatedOutline$removeTear()}}
\item \href{#method-checkTears}{\code{AnnotatedOutline$checkTears()}}
\item \href{#method-setFixedPoint}{\code{AnnotatedOutline$setFixedPoint()}}
\item \href{#method-getFixedPoint}{\code{AnnotatedOutline$getFixedPoint()}}
\item \href{#method-getRimSet}{\code{AnnotatedOutline$getRimSet()}}
\item \href{#method-ensureFixedPointInRim}{\code{AnnotatedOutline$ensureFixedPointInRim()}}
\item \href{#method-getRimLengths}{\code{AnnotatedOutline$getRimLengths()}}
\item \href{#method-clone}{\code{AnnotatedOutline$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-clearFeatureSets}{\code{retistruct::OutlineCommon$clearFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSet">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSet}{\code{retistruct::OutlineCommon$getFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSets}{\code{retistruct::OutlineCommon$getFeatureSets()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes">}\href{../../retistruct/html/OutlineCommon.html#method-getFeatureSetTypes}{\code{retistruct::OutlineCommon$getFeatureSetTypes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs">}\href{../../retistruct/html/OutlineCommon.html#method-getIDs}{\code{retistruct::OutlineCommon$getIDs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="addFeatureSet">}\href{../../retistruct/html/Outline.html#method-addFeatureSet}{\code{retistruct::Outline$addFeatureSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getImage">}\href{../../retistruct/html/Outline.html#method-getImage}{\code{retistruct::Outline$getImage()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineLengths">}\href{../../retistruct/html/Outline.html#method-getOutlineLengths}{\code{retistruct::Outline$getOutlineLengths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getOutlineSet">}\href{../../retistruct/html/Outline.html#method-getOutlineSet}{\code{retistruct::Outline$getOutlineSet()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPoints">}\href{../../retistruct/html/Outline.html#method-getPoints}{\code{retistruct::Outline$getPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="getPointsScaled">}\href{../../retistruct/html/Outline.html#method-getPointsScaled}{\code{retistruct::Outline$getPointsScaled()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapFragment">}\href{../../retistruct/html/Outline.html#method-mapFragment}{\code{retistruct::Outline$mapFragment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="mapPids">}\href{../../retistruct/html/Outline.html#method-mapPids}{\code{retistruct::Outline$mapPids()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Outline" data-id="replaceImage">}\href{../../retistruct/html/Outline.html#method-replaceImage}{\code{retistruct::Outline$replaceImage()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="addPoints">}\href{../../retistruct/html/PathOutline.html#method-addPoints}{\code{retistruct::PathOutline$addPoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="insertPoint">}\href{../../retistruct/html/PathOutline.html#method-insertPoint}{\code{retistruct::PathOutline$insertPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="nextPoint">}\href{../../retistruct/html/PathOutline.html#method-nextPoint}{\code{retistruct::PathOutline$nextPoint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="PathOutline" data-id="stitchSubpaths">}\href{../../retistruct/html/PathOutline.html#method-stitchSubpaths}{\code{retistruct::PathOutline$stitchSubpaths()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters to \code{\link{PathOutline}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-labelTearPoints"></a>}}
\if{latex}{\out{\hypertarget{method-labelTearPoints}{}}}
\subsection{Method \code{labelTearPoints()}}{
Label a set of three unlabelled points supposed
  to refer to the apex and vertices of a cut and tear with the \code{V0}
  (Apex), \code{VF} (forward vertex) and \code{VB} (backward vertex) labels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$labelTearPoints(pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{the vector of three indices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of indices labelled with \code{V0}, \code{VF} and \code{VB}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-whichTear"></a>}}
\if{latex}{\out{\hypertarget{method-whichTear}{}}}
\subsection{Method \code{whichTear()}}{
Return index of tear in an AnnotatedOutline in which a point appears
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$whichTear(pid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pid}}{ID of point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ID of tear
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTear"></a>}}
\if{latex}{\out{\hypertarget{method-getTear}{}}}
\subsection{Method \code{getTear()}}{
Return indices of tear in AnnotatedOutline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$getTear(tid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tid}}{Tear ID, which can be returned from \code{whichTear()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of three point IDs, labelled with \code{V0},
\code{VF} and \code{VB}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTears"></a>}}
\if{latex}{\out{\hypertarget{method-getTears}{}}}
\subsection{Method \code{getTears()}}{
Get tears
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$getTears()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Matrix of tears
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-computeTearRelationships"></a>}}
\if{latex}{\out{\hypertarget{method-computeTearRelationships}{}}}
\subsection{Method \code{computeTearRelationships()}}{
Compute the parent relationships for a potential
  set of tears. The function throws an error if tears overlap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$computeTearRelationships(tears = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tears}}{Matrix containing columns \code{V0} (Apices of tears) 
\code{VB} (Backward vertices of tears) and \code{VF} (Forward
vertices of tears)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List containing
\itemize{
\item{\code{Rset}}{the set of points on the rim}
\item{\code{TFset}}{list containing indices of points in each forward tear}
\item{\code{TBset}}{list containing indices of points in each backward tear}
\item{\code{h}}{correspondence mapping}
\item{\code{hf}}{correspondence mapping in forward direction for
        points on boundary}
\item{\code{hb}}{correspondence mapping in backward direction for
        points on boundary}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTear"></a>}}
\if{latex}{\out{\hypertarget{method-addTear}{}}}
\subsection{Method \code{addTear()}}{
Add tear to an AnnotatedOutline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$addTear(pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{Vector of three point IDs to be added}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeTear"></a>}}
\if{latex}{\out{\hypertarget{method-removeTear}{}}}
\subsection{Method \code{removeTear()}}{
Remove tear from an AnnotatedOutline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$removeTear(tid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tid}}{Tear ID, which can be returned from \code{whichTear()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkTears"></a>}}
\if{latex}{\out{\hypertarget{method-checkTears}{}}}
\subsection{Method \code{checkTears()}}{
Check that all tears are correct.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$checkTears()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
If all is OK, returns empty vector.  If not, returns
  indices of problematic tears.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setFixedPoint"></a>}}
\if{latex}{\out{\hypertarget{method-setFixedPoint}{}}}
\subsection{Method \code{setFixedPoint()}}{
Set fixed point
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$setFixedPoint(i0, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i0}}{Index of fixed point}

\item{\code{name}}{Name of fixed point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFixedPoint"></a>}}
\if{latex}{\out{\hypertarget{method-getFixedPoint}{}}}
\subsection{Method \code{getFixedPoint()}}{
Get point ID of fixed point
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$getFixedPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Point ID of fixed point
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRimSet"></a>}}
\if{latex}{\out{\hypertarget{method-getRimSet}{}}}
\subsection{Method \code{getRimSet()}}{
Get point IDs of points on rim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$getRimSet()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Point IDs of points on rim
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ensureFixedPointInRim"></a>}}
\if{latex}{\out{\hypertarget{method-ensureFixedPointInRim}{}}}
\subsection{Method \code{ensureFixedPointInRim()}}{
Ensure that the fixed point \code{i0} is in the rim, not a tear.
Alters object in which \code{i0} may have been changed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$ensureFixedPointInRim()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRimLengths"></a>}}
\if{latex}{\out{\hypertarget{method-getRimLengths}{}}}
\subsection{Method \code{getRimLengths()}}{
Get lengths of edges on rim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$getRimLengths()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of rim lengths
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AnnotatedOutline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
