% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retistruct-cli.R
\name{retistruct.cli}
\alias{retistruct.cli}
\title{Process a dataset with a time limit}
\usage{
retistruct.cli(dataset, cpu.time.limit = Inf, outputdir = NA,
  device = "pdf", ...)
}
\arguments{
\item{dataset}{Path to dataset to process}

\item{cpu.time.limit}{Time limit in seconds}

\item{outputdir}{Directory in which to save any figures}

\item{device}{String representing device to print figures to}

\item{...}{Other arguments to pass to \code{\link{retistruct.cli.process}}}
}
\value{
A list comprising
\item{\code{status}}{0 for success, 1 for reaching
\code{cpu.time.limit} and 2 for an unknown error}
\item{\code{time}}{The time take in seconds}
\item{\code{mess}}{Any error message}
}
\description{
This calls \code{\link{retistruct.cli.process}} with a time limit
specified by \code{cpu.time.limit}.
}
\author{
David Sterratt
}
