/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing;

import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.memory.trailing.trail.StoredIntVectorTrail;

public final class StoredIntVector
extends IStateIntVector {
    public int[] worldStamps;
    protected final StoredIntVectorTrail myTrail;

    public StoredIntVector(EnvironmentTrailing env, int initialSize, int initialValue) {
        super(env, initialSize, initialValue);
        int initialCapacity = Math.max(8, initialSize);
        int w = env.getWorldIndex();
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.worldStamps[i] = w;
        }
        this.myTrail = env.getIntVectorTrail();
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int[] oldStamps = this.worldStamps;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            this.worldStamps = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
            System.arraycopy(oldStamps, 0, this.worldStamps, 0, this.size.get());
        }
    }

    @Override
    public void add(int i) {
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        this.worldStamps[newsize - 1] = this.environment.getWorldIndex();
    }

    public void remove(int i) {
        System.arraycopy(this.elementData, i, this.elementData, i + 1, this.size.get());
        System.arraycopy(this.worldStamps, i, this.worldStamps, i + 1, this.size.get());
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    public void removeLast() {
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public int set(int index, int val) {
        if (this.rangeCheck(index)) {
            return this.quickSet(index, val);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public final int quickSet(int index, int val) {
        assert (this.rangeCheck(index));
        int oldValue = this.elementData[index];
        if (val != oldValue) {
            int oldStamp = this.worldStamps[index];
            if (oldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, index, oldValue, oldStamp);
                this.worldStamps[index] = this.environment.getWorldIndex();
            }
            this.elementData[index] = val;
        }
        return oldValue;
    }

    public int _set(int index, int val, int stamp) {
        assert (this.rangeCheck(index));
        int oldval = this.elementData[index];
        this.elementData[index] = val;
        this.worldStamps[index] = stamp;
        return oldval;
    }
}

