% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_helpers.R
\name{ith_mbl_neighbor}
\alias{ith_mbl_neighbor}
\title{An iterator for local prediction data in mbl}
\usage{
ith_mbl_neighbor(
  Xr,
  Xu = NULL,
  Yr,
  Yu = NULL,
  diss_usage = "none",
  neighbor_indices,
  neighbor_diss = NULL,
  diss_xr_xr = NULL,
  group = NULL
)
}
\arguments{
\item{Xr}{the Xr matrix in mbl.}

\item{Xu}{the Xu matrix in mbl. Default \code{NULL}. If not provided, the
function will iterate for each \code{\{Yr, Xr\}} to get the respective neighbors.}

\item{Yr}{the Yr matrix in mbl.}

\item{Yu}{the Yu matrix in mbl. Default \code{NULL}.}

\item{diss_usage}{a character string indicating if the dissimilarity data
will be used as predictors ("predictors") or not ("none").}

\item{neighbor_indices}{a matrix with the indices of neighbors of every Xu
found in Xr.}

\item{neighbor_diss}{a matrix with the dissimilarity socres for the neighbors
of every Xu found in Xr. This matrix is organized in the same way as
\code{neighbor_indices}.}

\item{diss_xr_xr}{a dissimilarity matrix between sampes in Xr.}

\item{group}{a factor representing the group labels of Xr.}
}
\value{
an object of \code{class} iterator giving the following list:
\itemize{
\item{ith_xr: the Xr data of the neighbors for the ith observation (if
\code{diss_usage = "predictors"}, this data is combined with the local
dissmilarity scores of the neighbors of Xu (or Xr if Xu was not provided))}
\item{ith_yr: the Yr data of the neighbors for the ith observation}
\item{ith_xu: the ith Xu observation (or Xr if Xu was not provided).
If \code{diss_usage = "predictors"}, this data is combined with the local
dissmilarity scores to its Xr neighbors.}
\item{ith_yu: the ith Yu observation (or Yr observation if Xu was not provided).}
\item{ith_neigh_diss: the dissimilarity scores of the neighbors for the ith
observation.}
\item{ith_group: the group labels for ith_xr.}
\item{n_k: the number of neighbors.}
}
}
\description{
internal function. It collects only the data necessary to
execute a local prediction for the mbl function based on a list of neighbors.
Not valid for local dissmilitary (e.g. for ortho_diss(...., .local = TRUE))
}
\details{
isubset will look at the order of knn in each col of D and
re-organize the rows of x accordingly
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
