% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackPredict.R
\name{PackPredict}
\alias{PackPredict}
\title{Compute class predictions for each observation in X}
\usage{
PackPredict(X, num.cores = 1)
}
\arguments{
\item{X}{an n by d numeric matrix (preferable) or data frame. The rows correspond to observations and columns correspond to features of a test set, which should be different from the training set.}

\item{num.cores}{the number of cores to use while predicting. (num.cores=0)}
}
\value{
predictions an n length vector of prediction class numbers
}
\description{
Predicts the classification of samples using a trained forest.
}
\examples{
library(rerf)
trainIdx <- c(1:40, 51:90, 101:140)
X <- as.matrix(iris[, 1:4])
Y <- as.numeric(iris[, 5])

paramList <- list(p = ncol(X), d = ceiling(sqrt(ncol(X))))

forest <- RerF(X, Y, FUN = RandMatRF, paramList = paramList, rfPack = TRUE, num.cores = 1)

predictions <- PackPredict(X)
}
