% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{RandMat}
\alias{RandMat}
\title{Create a Random Matrix}
\usage{
RandMat(mat.options)
}
\arguments{
\item{mat.options}{a list of parameters specifying the distribution
for sampling the random matrix. The first element specifies the
dimensionality p of the data (# features). The second element
specifies the number of columns d in the random matrix. The third
element specifies the "type" of distribution. The types of
distributions supported thus far are: "binary", "continuous",
"poisson", "rf", "frc", and "frcn." The fourth element specifies the
average density (proportion of nonzeros) rho of the random matrix.
For the "binary" distribution, rho is a real number between 0 and 1.
rho*d*p elements of the matrix are randomly chosen to be nonzero.
Each nonzero is randomly assigned -1 or 1 with equal probability. The
"continuous" distribution is the same as "binary", except the
nonzeros are sampled iid from the standard normal distribution.
"poisson" samples the number of nonzeros for each of the d columns
from a poisson(rho) distribution (rho is an integer >= 1). The
location of nonzeros in each column is randomly chosen, and the
nonzeros are assigned -1 or 1 with equal probability. "rf" randomly
samples d indices in {1,...,p} without replacement (d <= p is
required). Each of the d columns in the random matrix has a single
nonzero placed at the respective sampled index. This is equivalent to
the canonical random forest algorithm, which subsamples variables at
each node. Note that rho is irrelevant. "frc" is Breiman's forest-RC
algorithm, which samples rho nonzeros for each of the d columns (rho
must be an integer >= 1). The location of nonzeros in each column is
randomly chosen, and each nonzero location is assigned a value
uniformly randomly over the interval [-1,1]. "frcn" is the same as
"frc" except the nonzeros are sampled from the standard normal
distribution.}
}
\value{
random.matrix
}
\description{
Create a random matrix. At each node of a tree, a p-by-d random
matrix is sampled and used to generate a new set of d features, each
of which is a linear combination of the original p features. Thus,
the columns of the random matrix can be viewed as a set of bases in a
new feature space.
}
