% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud.R
\name{cloudUploadFromCache}
\alias{cloudUploadFromCache}
\title{Upload a file to cloud directly from local \code{cacheRepo}}
\usage{
cloudUploadFromCache(
  isInCloud,
  outputHash,
  saved,
  cacheRepo,
  cloudFolderID,
  outputToSave,
  rasters
)
}
\arguments{
\item{isInCloud}{A logical indicating whether an \code{outputHash} is in the cloud already.}

\item{outputHash}{The \code{cacheId} of the object to upload}

\item{saved}{The character string of the saved file's digest value.}

\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{cloudFolderID}{A googledrive dribble of a folder, e.g., using \code{drive_mkdir()}.
If left as \code{NULL}, the function will create a cloud folder with name from last
two folder levels of the \code{cacheRepo} path, :
\code{paste0(basename(dirname(cacheRepo)), "_", basename(cacheRepo))}.
This \code{cloudFolderID} will be added to \code{options("reproducible.cloudFolderID")},
but this will not persist across sessions. If this is a character string, it will
treat this as a folder name to create or use on GoogleDrive.}

\item{outputToSave}{Only required if \code{any(rasters) == TRUE}.
This is the \code{Raster*} object.}

\item{rasters}{A logical vector of length >= 1 indicating which elements in
\code{outputToSave} are \code{Raster*} objects.}
}
\description{
Meant for internal use, as there are internal objects as arguments.
}
\keyword{internal}
