% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{searchFull}
\alias{searchFull}
\alias{searchFullEx}
\title{Search up the full scope for functions}
\usage{
searchFull(env = parent.frame(), simplify = TRUE)

searchFullEx()
}
\arguments{
\item{env}{The environment to start searching at. Default is
calling environment, i.e., \code{parent.frame()}}

\item{simplify}{Logical. Should the output be simplified to character,
where possible}
}
\value{
Similar to \code{readLines}. It may not return identical results.
}
\description{
This is like \code{base::search} but when used inside a function, it will
show the full scope (see figure in the section \emph{Binding environments}
on \url{http://adv-r.had.co.nz/Environments.html}).
This full search path will be potentially much longer than
just \code{search()} (which always starts at \code{.GlobalEnv}).

\code{searchFullEx} shows an example function that is inside this package
whose only function is to show the Scope of a package function.


}
\examples{
seeScope <- function() {
  searchFull()
}
seeScope()
searchFull()

searchFullEx()
}
